/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.modifier.RbelHttpHeaderWriter;
import de.gematik.rbellogger.modifier.RbelHttpResponseWriter;
import de.gematik.rbellogger.modifier.RbelJsonWriter;
import de.gematik.rbellogger.modifier.RbelModificationDescription;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelModifier {
    private final RbelKeyManager rbelKeyManager;
    private final RbelConverter rbelConverter;
    private final List<RbelElementWriter> elementWriterList = new ArrayList<RbelJsonWriter>(List.of(new RbelHttpHeaderWriter(), new RbelHttpResponseWriter(), new RbelJsonWriter()));
    private final Map<String, RbelModificationDescription> modificationsMap = new HashMap<String, RbelModificationDescription>();

    public RbelElement applyModifications(RbelElement message) {
        RbelElement modifiedMessage = message;
        for (RbelModificationDescription modification : this.modificationsMap.values()) {
            if (!this.shouldBeApplied(modification, message)) continue;
            modifiedMessage = this.rbelConverter.convertElement(this.applyModification(modification, modifiedMessage), null);
        }
        return modifiedMessage;
    }

    private boolean shouldBeApplied(RbelModificationDescription modification, RbelElement message) {
        if (StringUtils.isEmpty((CharSequence)modification.getCondition())) {
            return true;
        }
        RbelJexlExecutor executor = new RbelJexlExecutor();
        return executor.matchesAsJexlExpression(message, modification.getCondition(), Optional.empty());
    }

    private String applyModification(RbelModificationDescription modification, RbelElement message) {
        RbelElement targetElement = message.findElement(modification.getTargetElement()).orElseThrow(() -> new RbelModificationException("Could not find element " + modification.getTargetElement() + " in message!"));
        RbelElement oldTargetModifiedChild = targetElement;
        String newContent = this.applyRegexAndReturnNewContent(targetElement, modification);
        for (RbelElement oldTargetElement = targetElement.getParentNode(); oldTargetElement != null; oldTargetElement = oldTargetElement.getParentNode()) {
            Optional<Object> found = Optional.empty();
            for (RbelElementWriter writer : this.elementWriterList) {
                if (!writer.canWrite(oldTargetElement)) continue;
                String write = writer.write(oldTargetElement, oldTargetModifiedChild, newContent);
                found = Optional.of(write);
                break;
            }
            if (found.isEmpty()) {
                throw new RbelModificationException("Could not rewrite element with facets " + oldTargetElement.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toList()) + "!");
            }
            newContent = (String)found.get();
            oldTargetModifiedChild = oldTargetElement;
        }
        return newContent;
    }

    private String applyRegexAndReturnNewContent(RbelElement targetElement, RbelModificationDescription modification) {
        if (StringUtils.isEmpty((CharSequence)modification.getRegexFilter())) {
            return modification.getReplaceWith();
        }
        return targetElement.getRawStringContent().replaceAll(modification.getRegexFilter(), modification.getReplaceWith());
    }

    public void deleteAllModifications() {
        this.modificationsMap.clear();
    }

    public void addModification(RbelModificationDescription modificationDescription) {
        this.modificationsMap.put(modificationDescription.getName(), modificationDescription);
    }

    @Generated
    public static RbelModifierBuilder builder() {
        return new RbelModifierBuilder();
    }

    @ConstructorProperties(value={"rbelKeyManager", "rbelConverter"})
    @Generated
    public RbelModifier(RbelKeyManager rbelKeyManager, RbelConverter rbelConverter) {
        this.rbelKeyManager = rbelKeyManager;
        this.rbelConverter = rbelConverter;
    }

    @Generated
    public static class RbelModifierBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private RbelConverter rbelConverter;

        @Generated
        RbelModifierBuilder() {
        }

        @Generated
        public RbelModifierBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelModifierBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        public RbelModifier build() {
            return new RbelModifier(this.rbelKeyManager, this.rbelConverter);
        }

        @Generated
        public String toString() {
            return "RbelModifier.RbelModifierBuilder(rbelKeyManager=" + this.rbelKeyManager + ", rbelConverter=" + this.rbelConverter + ")";
        }
    }

    private class RbelModificationException
    extends RuntimeException {
        public RbelModificationException(String s) {
            super(s);
        }
    }
}

