/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.key;

import java.beans.ConstructorProperties;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Optional;
import lombok.Generated;

public class RbelKey {
    public static final int PRECEDENCE_X5C_HEADER_VALUE = 100;
    public static final int PRECEDENCE_KEY_FOLDER = 110;
    private final Key key;
    private final String keyName;
    private final int precedence;
    private final Optional<RbelKey> matchingPublicKey;

    public RbelKey(Key key, String keyName, int precedence, RbelKey matchingPublicKey) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.matchingPublicKey = Optional.ofNullable(matchingPublicKey);
    }

    public RbelKey(Key key, String keyName, int precedence) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.matchingPublicKey = Optional.empty();
    }

    public Optional<KeyPair> retrieveCorrespondingKeyPair() {
        if (this.key instanceof PrivateKey) {
            return this.matchingPublicKey.map(RbelKey::getKey).filter(PublicKey.class::isInstance).map(PublicKey.class::cast).map(pubKey -> new KeyPair((PublicKey)pubKey, (PrivateKey)this.key));
        }
        return Optional.empty();
    }

    @Generated
    public static RbelKeyBuilder builder() {
        return new RbelKeyBuilder();
    }

    @Generated
    public Key getKey() {
        return this.key;
    }

    @Generated
    public String getKeyName() {
        return this.keyName;
    }

    @Generated
    public int getPrecedence() {
        return this.precedence;
    }

    @Generated
    public Optional<RbelKey> getMatchingPublicKey() {
        return this.matchingPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelKey)) {
            return false;
        }
        RbelKey other = (RbelKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$key = this.getKey();
        Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$keyName = this.getKeyName();
        String other$keyName = other.getKeyName();
        if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
            return false;
        }
        if (this.getPrecedence() != other.getPrecedence()) {
            return false;
        }
        Optional<RbelKey> this$matchingPublicKey = this.getMatchingPublicKey();
        Optional<RbelKey> other$matchingPublicKey = other.getMatchingPublicKey();
        return !(this$matchingPublicKey == null ? other$matchingPublicKey != null : !((Object)this$matchingPublicKey).equals(other$matchingPublicKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $keyName = this.getKeyName();
        result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
        result = result * 59 + this.getPrecedence();
        Optional<RbelKey> $matchingPublicKey = this.getMatchingPublicKey();
        result = result * 59 + ($matchingPublicKey == null ? 43 : ((Object)$matchingPublicKey).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelKey(key=" + this.getKey() + ", keyName=" + this.getKeyName() + ", precedence=" + this.getPrecedence() + ", matchingPublicKey=" + this.getMatchingPublicKey() + ")";
    }

    @ConstructorProperties(value={"key", "keyName", "precedence", "matchingPublicKey"})
    @Generated
    public RbelKey(Key key, String keyName, int precedence, Optional<RbelKey> matchingPublicKey) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.matchingPublicKey = matchingPublicKey;
    }

    @Generated
    public static class RbelKeyBuilder {
        @Generated
        private Key key;
        @Generated
        private String keyName;
        @Generated
        private int precedence;
        @Generated
        private Optional<RbelKey> matchingPublicKey;

        @Generated
        RbelKeyBuilder() {
        }

        @Generated
        public RbelKeyBuilder key(Key key) {
            this.key = key;
            return this;
        }

        @Generated
        public RbelKeyBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Generated
        public RbelKeyBuilder precedence(int precedence) {
            this.precedence = precedence;
            return this;
        }

        @Generated
        public RbelKeyBuilder matchingPublicKey(Optional<RbelKey> matchingPublicKey) {
            this.matchingPublicKey = matchingPublicKey;
            return this;
        }

        @Generated
        public RbelKey build() {
            return new RbelKey(this.key, this.keyName, this.precedence, this.matchingPublicKey);
        }

        @Generated
        public String toString() {
            return "RbelKey.RbelKeyBuilder(key=" + this.key + ", keyName=" + this.keyName + ", precedence=" + this.precedence + ", matchingPublicKey=" + this.matchingPublicKey + ")";
        }
    }
}

