/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.application;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JBufferInputStream;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.protocol.tcpip.Http;

@Header
public class WebImage
extends JHeader {
    private byte[] data;

    @Bind(to=Http.class)
    public static boolean bind2Http(JPacket jPacket, Http http) {
        Http.ContentType contentType = http.contentTypeEnum();
        switch (contentType) {
            case JPEG: 
            case PNG: 
            case GIF: {
                return true;
            }
        }
        return false;
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return jBuffer.size() - n;
    }

    protected void decodeHeader() {
        this.data = null;
    }

    public Image getAWTImage() {
        if (this.data == null) {
            this.data = super.getByteArray(0, this.size());
        }
        return Toolkit.getDefaultToolkit().createImage(this.data);
    }

    public InputStream getInputStream() {
        return new JBufferInputStream(this);
    }

    public int length() {
        return this.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BMP,
        GIF,
        JPEG,
        SVG;

    }
}

