/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.jnetpcap.Pcap;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Icmp;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.network.Ip6;
import org.jnetpcap.protocol.tcpip.Tcp;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.util.DataUtils;
import org.jnetpcap.util.PcapPacketArrayList;
import org.jnetpcap.util.checksum.Checksum;

public class TestTcpIp
extends TestUtils {
    public static final String HTTP_IP6 = "tests/v6-http.cap";
    public static final String SMALL_IMAP = "tests/test-small-imap.pcap";
    List<Integer> checksums = new ArrayList<Integer>();
    List<Integer> saved = new ArrayList<Integer>();
    List<byte[]> data = new ArrayList<byte[]>();

    public void testIp4CRC16Pkt1() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        int n = Checksum.inChecksum(ip4, 0, ip4.size());
        System.out.printf("1chunk=%x\n", n);
        System.out.printf("shoudbe=%x checksum=%x\n", Checksum.inChecksumShouldBe(ip4.checksum(), n), ip4.checksum());
        TestTcpIp.assertTrue((boolean)ip4.isChecksumValid());
    }

    public void testIp4CRC16Pkt2() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 1);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestTcpIp.assertEquals((int)ip4.calculateChecksum(), (int)ip4.checksum());
    }

    public void testIp4CRC16Pkt50() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 45);
        Ip4 ip4 = pcapPacket.getHeader(new Ip4());
        TestTcpIp.assertEquals((int)ip4.checksum(), (int)ip4.calculateChecksum());
    }

    public void testIp4CRC16EntireFile() throws InterruptedException {
        Ip4 ip4 = new Ip4();
        for (PcapPacket pcapPacket : TestUtils.getIterable("tests/test-l2tp.pcap")) {
            Thread.sleep(10L);
            long l = pcapPacket.getFrameNumber() + 1L;
            TestTcpIp.assertTrue((boolean)pcapPacket.hasHeader(ip4));
            TestTcpIp.assertEquals((int)20, (int)ip4.size());
            int n = ip4.calculateChecksum();
            if (ip4.checksum() != n) {
                try {
                    System.out.println(pcapPacket.getState().toDebugString());
                    System.out.println(pcapPacket);
                }
                catch (Exception exception) {
                    System.out.println(pcapPacket.getState().toDebugString());
                    exception.printStackTrace();
                }
                System.out.printf("#%d: ip.crc=%x computed=%x\n", l, ip4.checksum(), n);
                System.out.println(ip4.toHexdump());
            }
            TestTcpIp.assertEquals((String)("Frame #" + l), (int)ip4.checksum(), (int)n);
        }
    }

    public void testIp4CRC16UsingHandler() {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline("tests/test-l2tp.pcap", stringBuilder);
        TestTcpIp.assertNotNull((Object)pcap);
        pcap.dispatch(-1, 1, new PcapPacketHandler<Pcap>(){
            Ip4 ip = new Ip4();
            int i = 0;
            int j = 0;

            @Override
            public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                ++this.j;
                long l = pcapPacket.getFrameNumber();
                Assert.assertTrue((String)("#" + l), (boolean)pcapPacket.hasHeader(this.ip));
                System.out.println(pcapPacket.getState().toDebugString());
                Assert.assertTrue((String)("Frame #" + l), (boolean)this.ip.isChecksumValid());
            }
        }, null);
    }

    public void testCompare2SetsOfPackets() throws IOException {
        List<PcapPacket> list = this.getPacketList("tests/test-l2tp.pcap");
        List<PcapPacket> list2 = this.getPacketList("tests/test-l2tp.pcap");
        TestTcpIp.assertEquals((int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            PcapPacket pcapPacket = list.get(i);
            PcapPacket pcapPacket2 = list2.get(i);
            if (pcapPacket.size() != pcapPacket2.size()) {
                System.out.printf("#%d p1=%d p2=%d\n%s\n%s\n", i, list.size(), list2.size(), pcapPacket.toHexdump(), pcapPacket2.toHexdump());
                System.out.println(pcapPacket.toString());
                System.out.println(pcapPacket2.toString());
            }
            TestTcpIp.assertEquals((int)pcapPacket.size(), (int)pcapPacket2.size());
            TestTcpIp.assertTrue((boolean)this.compareJBuffer(pcapPacket, pcapPacket2));
        }
    }

    public void testCompareChecksumOf2Sets() throws IOException {
        List<PcapPacket> list = this.getPacketList("tests/test-l2tp.pcap");
        List<PcapPacket> list2 = this.getPacketList("tests/test-l2tp.pcap");
        TestTcpIp.assertEquals((int)list.size(), (int)list2.size());
        Ip4 ip4 = new Ip4();
        Ip4 ip42 = new Ip4();
        for (int i = 0; i < list.size(); ++i) {
            PcapPacket pcapPacket = list.get(i);
            PcapPacket pcapPacket2 = list2.get(i);
            int n = pcapPacket.getHeader(ip4).calculateChecksum();
            int n2 = pcapPacket2.getHeader(ip42).calculateChecksum();
            System.out.println(ip4);
            System.out.println(ip42);
            TestTcpIp.assertEquals((int)n, (int)ip4.checksum());
            TestTcpIp.assertEquals((int)n2, (int)ip42.checksum());
            TestTcpIp.assertEquals((int)n, (int)n2);
        }
    }

    private boolean compareJBuffer(JBuffer jBuffer, JBuffer jBuffer2) {
        if (jBuffer.size() != jBuffer2.size()) {
            return false;
        }
        for (int i = 0; i < jBuffer.size(); ++i) {
            if (jBuffer.getByte(i) == jBuffer2.getByte(i)) continue;
            return false;
        }
        return true;
    }

    private List<PcapPacket> getPacketList(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(string, stringBuilder);
        if (pcap == null) {
            throw new IOException(stringBuilder.toString());
        }
        PcapPacketArrayList pcapPacketArrayList = new PcapPacketArrayList((int)new File(string).length() / 100);
        pcap.loop(-1, pcapPacketArrayList, null);
        pcap.close();
        return pcapPacketArrayList;
    }

    public void testIpChecksum() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline("tests/test-l2tp.pcap", stringBuilder);
        if (pcap == null) {
            throw new IOException(stringBuilder.toString());
        }
        TestTcpIp.assertTrue((pcap.loop(-1, new PcapPacketHandler<Pcap>(){
            Ip4 ip1 = new Ip4();
            Ip4 ip2 = new Ip4();
            int i = 0;

            @Override
            public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                ++this.i;
                pcapPacket.getHeader(this.ip1);
                int n = this.ip1.calculateChecksum();
                PcapPacket pcapPacket2 = new PcapPacket(pcapPacket);
                pcapPacket2.getHeader(this.ip2);
                int n2 = this.ip2.calculateChecksum();
                if (n != n2) {
                    System.out.printf("#%d crc_before=%x crc_after=%x\n", this.i, n, n2);
                    System.out.printf("P1: %s\nheader1=%s\n\nstate1=%s\npacket1=%s\n\nip1=%s\n", pcapPacket.toHexdump(), pcapPacket.getCaptureHeader().toDebugString(), pcapPacket.getState().toDebugString(), pcapPacket.toDebugString(), this.ip1.toDebugString());
                    System.out.println("---------------------------");
                    System.out.printf("P2: %s\nheader2=%s\n\nstate2=%s\npacket2=%s\n\nip2=%s\n\n", pcapPacket2.toHexdump(), pcapPacket2.getCaptureHeader().toDebugString(), pcapPacket2.getState().toDebugString(), pcapPacket2.toDebugString(), this.ip2.toDebugString());
                    System.out.println("p1-p2.memory.diff=\n" + FormatUtils.hexdump(DataUtils.diff(pcapPacket, (JBuffer)pcapPacket2)));
                    System.out.println("ip1-ip2.memory.diff=\n" + FormatUtils.hexdump(DataUtils.diff(this.ip1, (JBuffer)this.ip2)));
                    pcap.breakloop();
                }
                ++this.i;
            }
        }, pcap) != -2 ? 1 : 0) != 0);
        pcap.close();
    }

    public void testCompare2SetsOfPackets2() throws IOException {
        List<PcapPacket> list = this.getPacketList("tests/test-l2tp.pcap");
        List<PcapPacket> list2 = this.getPacketList("tests/test-l2tp.pcap");
        Ip4 ip4 = new Ip4();
        Ip4 ip42 = new Ip4();
        TestTcpIp.assertEquals((int)list.size(), (int)list2.size());
        System.out.println("------------------------------\n");
        for (int i = 0; i < list.size(); ++i) {
            PcapPacket pcapPacket = list.get(i);
            PcapPacket pcapPacket2 = list2.get(i);
            pcapPacket.getHeader(ip4);
            pcapPacket2.getHeader(ip42);
            TestTcpIp.assertTrue((String)"ip1.size() == p2.size()", (pcapPacket.size() == pcapPacket2.size() ? 1 : 0) != 0);
            TestTcpIp.assertTrue((String)ip4.toString(), (boolean)ip4.isChecksumValid());
            TestTcpIp.assertTrue((String)ip42.toString(), (boolean)ip42.isChecksumValid());
            TestTcpIp.assertTrue((boolean)this.compareJBuffer(pcapPacket, pcapPacket2));
        }
    }

    public void testTcpIp4CRC16UsingHandler() {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline("tests/test-http-jpeg.pcap", stringBuilder);
        TestTcpIp.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
        pcap.loop(-1, new PcapPacketHandler<String>(){
            Ip4 ip = new Ip4();
            Tcp tcp = new Tcp();

            @Override
            public void nextPacket(PcapPacket pcapPacket, String string) {
                if (!pcapPacket.hasHeader(this.tcp)) {
                    return;
                }
                long l = pcapPacket.getFrameNumber();
                Assert.assertTrue((String)("#" + l), (boolean)pcapPacket.hasHeader(this.ip));
                int n = Checksum.pseudoTcp(pcapPacket, this.ip.getOffset(), this.tcp.getOffset());
                if (n != 0 && this.tcp.checksum() != n) {
                    System.out.println(this.tcp);
                    System.out.printf("#%d: tcp.crc=%x computed=%x\n", l, this.tcp.checksum(), n);
                    System.exit(0);
                }
            }
        }, null);
    }

    public void testTcpIp6CRC16UsingHandler() {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(HTTP_IP6, stringBuilder);
        TestTcpIp.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
        pcap.loop(-1, new PcapPacketHandler<String>(){
            Ip6 ip = new Ip6();
            Tcp tcp = new Tcp();

            @Override
            public void nextPacket(PcapPacket pcapPacket, String string) {
                if (!pcapPacket.hasHeader(this.tcp)) {
                    return;
                }
                System.out.println(pcapPacket.toString());
                long l = pcapPacket.getFrameNumber();
                Assert.assertTrue((String)("#" + l), (boolean)pcapPacket.hasHeader(this.ip));
                Assert.assertTrue((String)("Frame #" + l), (boolean)this.tcp.isChecksumValid());
            }
        }, null);
    }

    public void testUdpIp6CRC16UsingHandler() {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline(HTTP_IP6, stringBuilder);
        TestTcpIp.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
        pcap.loop(-1, new PcapPacketHandler<String>(){
            Ip6 ip = new Ip6();
            Udp udp = new Udp();

            @Override
            public void nextPacket(PcapPacket pcapPacket, String string) {
                if (!pcapPacket.hasHeader(this.udp)) {
                    return;
                }
                long l = pcapPacket.getFrameNumber();
                Assert.assertTrue((String)("#" + l), (boolean)pcapPacket.hasHeader(this.ip));
                Assert.assertTrue((String)("Frame #" + l), (boolean)this.udp.isChecksumValid());
            }
        }, null);
    }

    public void testIcmpCRC16UsingHandler() {
        StringBuilder stringBuilder = new StringBuilder();
        Pcap pcap = Pcap.openOffline("tests/test-vlan.pcap", stringBuilder);
        TestTcpIp.assertNotNull((String)stringBuilder.toString(), (Object)pcap);
        pcap.loop(-1, new PcapPacketHandler<String>(){
            Ip4 ip = new Ip4();
            Icmp icmp = new Icmp();

            @Override
            public void nextPacket(PcapPacket pcapPacket, String string) {
                if (!pcapPacket.hasHeader(this.icmp)) {
                    return;
                }
                long l = pcapPacket.getFrameNumber();
                Assert.assertTrue((String)("#" + l), (boolean)pcapPacket.hasHeader(this.ip));
                if (!this.icmp.isChecksumValid()) {
                    System.out.printf("#%d shouldbe=%x checksum=%x\n", l, this.icmp.calculateChecksum(), this.icmp.checksum());
                }
                Assert.assertTrue((String)("#" + l), (boolean)this.icmp.isChecksumValid());
            }
        }, null);
    }

    public void testIp4FragmentFlagDirectly() {
        Icmp icmp;
        Ip4 ip4;
        Ethernet ethernet;
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-ipreassembly.pcap", 0);
        if (pcapPacket.hasHeader(ethernet = new Ethernet())) {
            TestTcpIp.assertNotSame((Object)256, (Object)(ethernet.getState().getFlags() & 0x100));
        }
        if (pcapPacket.hasHeader(ip4 = new Ip4())) {
            TestTcpIp.assertEquals((int)256, (int)(ip4.getState().getFlags() & 0x100));
        }
        if (pcapPacket.hasHeader(icmp = new Icmp())) {
            TestTcpIp.assertEquals((int)256, (int)(icmp.getState().getFlags() & 0x100));
        }
    }

    public void testJHeaderIsFragmented() {
        Icmp icmp;
        Ip4 ip4;
        Ethernet ethernet;
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-ipreassembly.pcap", 0);
        if (pcapPacket.hasHeader(ethernet = new Ethernet())) {
            TestTcpIp.assertFalse((boolean)ethernet.isFragmented());
        }
        if (pcapPacket.hasHeader(ip4 = new Ip4())) {
            TestTcpIp.assertTrue((boolean)ip4.isFragmented());
        }
        if (pcapPacket.hasHeader(icmp = new Icmp())) {
            TestTcpIp.assertTrue((boolean)ip4.isFragmented());
        }
    }

    public void testTcpOptions() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket(SMALL_IMAP, 0);
        System.out.println(pcapPacket.getState().toDebugString());
        System.out.println(pcapPacket.toString());
        Tcp tcp = pcapPacket.getHeader(new Tcp());
        Tcp.Timestamp timestamp = new Tcp.Timestamp();
        if (tcp.hasSubHeader(timestamp)) {
            System.out.printf("tsval=%d tsecr=%d%n", timestamp.tsval(), timestamp.tsecr());
        }
    }

    public void testFlagsToEnumSet() {
        int n = 18;
        Set<Tcp.Flag> set = Tcp.Flag.asSet(n);
        TestTcpIp.assertEquals((String)"[SYN, ACK]", (String)set.toString());
        TestTcpIp.assertEquals(EnumSet.of(Tcp.Flag.ACK, Tcp.Flag.SYN), set);
    }
}

