/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import junit.framework.TestCase;
import org.jnetpcap.protocol.JProtocol;
import org.junit.Test;

public class TestJProtocol {
    public void idToMask() {
        for (int i = 0; i < 1024; ++i) {
            long l = i >> 5;
            long l2 = l << 32 | 1L << (i & 0x1F);
            long l3 = JProtocol.idToMask(i);
            System.out.printf("#%4d = 0x%016X mapIndex=%d%n", i, l3, l);
            TestCase.assertEquals((String)String.format("expected: 0x%016X but was 0x%016X ---- ", l2, l3), (long)l2, (long)l3);
        }
        try {
            JProtocol.idToMask(1024);
            TestCase.fail((String)"value range is between 0 and 1024");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            JProtocol.idToMask(-1);
            TestCase.fail((String)"value range is between 0 and 256");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            JProtocol.idToMask(100000000);
            TestCase.fail((String)"value range is between 0 and 256");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMaskToId() {
        for (int i = 0; i < 1024; ++i) {
            long l = JProtocol.idToMask(i);
            int n = JProtocol.maskToId(l);
            TestCase.assertEquals((int)(i & 0x1F), (int)n);
        }
    }

    @Test
    public void testMaskToMapIndex() {
        for (int i = 0; i < 1024; ++i) {
            long l = JProtocol.idToMask(i);
            int n = JProtocol.maskToGroup(l);
            TestCase.assertEquals((int)(i >> 5), (int)n);
        }
    }
}

