/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapUtils;
import org.jnetpcap.nio.DisposableGC;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JPcapRecordBuffer;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.FormatUtils;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.protocol.tcpip.Tcp;

public class TestForMemoryLeaks
extends TestUtils {
    private static final File DIR = new File("tests");
    private static final int PEER_1S = 401;
    private static final int PEER_1M = 24060;
    private static final int PEER_1H = 1443600;
    private static final int PEER_3M_35S = 9000;
    private static final int TCP_SCAN_TRANSFERTO_1S = 100;
    private static final int TCP_SCAN_TRANSFERTO_1M = 6000;
    private static final int GENERAL_SCAN_TRANSFERTO_1S = 14;
    private static final int GENERAL_SCAN_TRANSFERTO_1M = 840;
    private static final int GENERAL_SCAN_TRANSFERTO__Q_1S = 12;
    private static final int GENERAL_SCAN_TRANSFERTO_Q_1M = 720;
    private static final int COUNT = 1680;
    private static final int LINES = 10;
    private StringBuilder errbuf;
    private final double G = 1.073741824E9;
    private final double g = 1.0E9;
    private final double M = 1048576.0;
    private final double K = 1024.0;
    private final double m = 1000000.0;
    private final double k = 1000.0;
    long b = 0L;
    long bytes = 0L;
    long h = 0L;
    long headers = 0L;
    long total = 0L;
    long start = 0L;
    long end = 0L;
    long count = 0L;
    long ts = 0L;
    long te = 0L;

    @Override
    protected void setUp() throws Exception {
        this.errbuf = new StringBuilder();
    }

    @Override
    protected void tearDown() throws Exception {
        this.errbuf = null;
    }

    public void testInjectTestJPacketHandler() throws SigarException {
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        JBuffer jBuffer = new JBuffer(FormatUtils.toByteArray("0007e914 78a20010 7b812445 080045c000280005 0000ff11 70e7c0a8 62dec0a865e906a5 06a50014 e04ac802 000c000200000002 00060000 00000000"));
        PcapHeader pcapHeader = new PcapHeader(jBuffer.size(), jBuffer.size());
        PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
        System.out.printf("injected packet size=%d bytes\n", jBuffer.size());
        for (int i = 0; i < 1680; ++i) {
            PcapUtils.injectLoop(1000, 1, new PcapPacketHandler<String>(){

                @Override
                public void nextPacket(PcapPacket pcapPacket, String string) {
                    Assert.assertNotNull((Object)pcapPacket);
                    ++TestForMemoryLeaks.this.count;
                    TestForMemoryLeaks.this.b += (long)pcapPacket.size();
                    TestForMemoryLeaks.this.h += (long)pcapPacket.getState().getHeaderCount();
                }
            }, "", pcapPacket);
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 168 != 0 || i == 0) continue;
            this.te = System.currentTimeMillis();
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            procMem.gather(sigar, l);
            System.out.printf("tot=%.1f packets=%d pps=%.0f bytes=%.0fKb/s hdr=%.0f/s hdr=%.0fus rm=%dKb pm=%.1fb vm=%dKb\n", (double)this.total / 1024.0 / 1024.0, this.count, (double)this.count / d, (double)this.b / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), procMem.getResident() / 1024L, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
            System.out.flush();
            this.ts = this.te;
            this.count = 0L;
            this.b = 0L;
            this.h = 0L;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }

    public void testStressTestJPacketHandler() throws SigarException {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.equals("test-sip-rtp-g711.pcap");
            }
        });
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        for (int i = 0; i < 1680; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                TestForMemoryLeaks.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new JPacketHandler<Pcap>(){

                    @Override
                    public void nextPacket(JPacket jPacket, Pcap pcap) {
                        Assert.assertNotNull((Object)jPacket);
                        ++TestForMemoryLeaks.this.count;
                        TestForMemoryLeaks.this.b += (long)jPacket.size();
                        TestForMemoryLeaks.this.h += (long)jPacket.getState().getHeaderCount();
                    }
                }, pcap);
                pcap.close();
            }
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 168 != 0 || i == 0) continue;
            this.te = System.currentTimeMillis();
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            procMem.gather(sigar, l);
            System.out.printf("tot=%.1fMpkts packets=%d pps=%.0f bytes=%.0fKb/s hdr=%.0f/s hdr=%.0fus rm=%dKb pm=%.1fb vm=%dKb\n", (double)this.total / 1000000.0, this.count, (double)this.count / d, (double)this.b / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), procMem.getResident() / 1024L, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
            System.out.flush();
            this.ts = this.te;
            this.count = 0L;
            this.b = 0L;
            this.h = 0L;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }

    public void testStressTestPcapPacketHandler() {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        });
        for (int i = 0; i < 168; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                TestForMemoryLeaks.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new PcapPacketHandler<Pcap>(){

                    @Override
                    public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                        Assert.assertNotNull((Object)pcapPacket);
                    }
                }, pcap);
                pcap.close();
            }
            if (i % 80 == 0) {
                System.out.println();
            }
            System.out.printf(".", new Object[0]);
            System.out.flush();
        }
        System.out.println();
    }

    public void testStressTestJBufferHandler() throws SigarException {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        });
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        final PcapPacket pcapPacket = new PcapPacket(JMemory.POINTER);
        int n = 0;
        for (int i = 0; i < 1680; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                TestForMemoryLeaks.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new JBufferHandler<Pcap>(){

                    @Override
                    public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                        ++TestForMemoryLeaks.this.count;
                        TestForMemoryLeaks.this.b += (long)jBuffer.size();
                        pcapPacket.peerAndScan(1, pcapHeader, jBuffer);
                        TestForMemoryLeaks.this.h += (long)pcapPacket.getState().getHeaderCount();
                    }
                }, pcap);
                pcap.close();
            }
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 168 != 0 || i == 0) continue;
            ++n;
            this.te = System.currentTimeMillis();
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            procMem.gather(sigar, l);
            System.out.printf("#%-2d %s: ", n, new Time(System.currentTimeMillis()));
            System.out.printf("tot=%.1fMp packets=%d pps=%.0f bytes=%.0fMb/s hdr=%.0f/s hdr=%.0fus rm=%.1fMb pm=%.1fb vm=%dKb\n", (double)this.total / 1000.0 / 1000.0, this.count, (double)this.count / d, (double)this.b / d / 1048576.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), (double)procMem.getResident() / 1048576.0, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
            System.out.flush();
            this.ts = this.te;
            this.count = 0L;
            this.b = 0L;
            this.h = 0L;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }

    public void testStressTestJBufferHandlerFromMemory() throws SigarException {
        String[] stringArray = TestForMemoryLeaks.getDirFileList(DIR, ".pcap");
        JPcapRecordBuffer jPcapRecordBuffer = TestForMemoryLeaks.loadAllPacketsFromFiles(stringArray);
        int n = jPcapRecordBuffer.getInt(0);
        int n2 = jPcapRecordBuffer.size();
        System.out.printf("Read %d files, with %d packets, for %d bytes\n", stringArray.length, n, n2);
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        final PcapPacket pcapPacket = new PcapPacket(JMemory.POINTER);
        int n3 = 0;
        Tcp tcp = new Tcp();
        JBufferHandler<Object> jBufferHandler = new JBufferHandler<Object>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Object object) {
                pcapPacket.peerAndScan(1, pcapHeader, jBuffer);
                TestForMemoryLeaks.this.h += (long)pcapPacket.getState().getHeaderCount();
            }
        };
        for (int i = 0; i < 1680; ++i) {
            this.b += (long)n2;
            this.count += jPcapRecordBuffer.dispatchToJBuffeHandler(jBufferHandler, null);
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 168 != 0 || i == 0) continue;
            ++n3;
            this.te = System.currentTimeMillis();
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            double d2 = (double)this.h / d;
            double d3 = 1.0E9 / ((double)this.h / d);
            procMem.gather(sigar, l);
            System.out.printf("#%-2d %s: ", n3, new Time(System.currentTimeMillis()));
            System.out.printf("tot=%.1fMp packets=%d pps=%.0f(%.1fus) hps=%.0f(%.0fns) bytes=%.0fMb/s rm=%.1fMb pm=%.1fb vm=%dKb%n", (double)this.total / 1000.0 / 1000.0, this.count, (double)this.count / d, d * 1000000.0 / (double)this.count, d2, Double.isInfinite(d3) ? 0.0 : d3, (double)this.b / d / 1048576.0, (double)procMem.getResident() / 1048576.0, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
            System.out.flush();
            this.ts = this.te;
            this.count = 0L;
            this.b = 0L;
            this.h = 0L;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        double d4 = (double)this.headers / 1000.0 / d;
        double d5 = 1.0E9 / ((double)this.headers / d);
        long l3 = (this.end - this.start) / 1000L;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L % 60L;
        long l6 = l3 / 3600L % 24L;
        System.out.printf("### %02d:%02d:%02d ", l6, l5, l4);
        System.out.printf("packets=%d(%.1fKpps, %.1fns/p) headers=%d(%.0fKhps, %.0fns/h) MBps=%.3f(%.3fMbps) %n", this.total, (double)this.total / d / 1000.0, d * 1.0E9 / (double)this.total, this.headers, d4, d5, (double)this.bytes / d / 1048576.0, (double)this.bytes * 8.0 / d / 1048576.0);
        System.out.flush();
    }

    public void testStressTestQueuedJBufferHandlerFromMemory() throws SigarException, InterruptedException {
        String[] stringArray = TestForMemoryLeaks.getDirFileList(DIR, ".pcap");
        JPcapRecordBuffer jPcapRecordBuffer = TestForMemoryLeaks.loadAllPacketsFromFiles(stringArray);
        int n = jPcapRecordBuffer.getInt(0);
        int n2 = jPcapRecordBuffer.size();
        System.out.printf("Read %d files, with %d packets, for %d bytes\n", stringArray.length, n, n2);
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        PcapPacket pcapPacket = new PcapPacket(JMemory.POINTER);
        JPacket.State state = pcapPacket.getState();
        Tcp tcp = new Tcp();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        ReferenceQueue referenceQueue = new ReferenceQueue();
        TextFormatter textFormatter = new TextFormatter(DEV_NULL);
        Thread.currentThread().setPriority(5);
        int n3 = 0;
        DisposableGC.getDefault().startCleanupThread();
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue(10);
        JBufferHandler<Object> jBufferHandler = new JBufferHandler<Object>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Object object) {
                TestForMemoryLeaks.this.b += (long)jBuffer.size();
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                ++TestForMemoryLeaks.this.count;
            }
        };
        for (int i = 0; i < 1680; ++i) {
            jPcapRecordBuffer.dispatchToJBuffeHandler(jBufferHandler, null);
            if (i == 0) {
                l2 = procMem.getResident();
            }
            if (i % 168 != 0 || i == 0) continue;
            ++n3;
            this.te = System.currentTimeMillis();
            procMem.gather(sigar, l);
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            double d2 = (double)this.h / d;
            double d3 = (double)this.b * 8.0 / d;
            double d4 = 1.0E9 / ((double)this.h / d);
            d4 = Double.isInfinite(d4) ? 0.0 : d4;
            double d5 = procMem.getResident() - l2;
            double d6 = procMem.getSize();
            System.out.printf("#%-2d %s: ", n3, new Time(System.currentTimeMillis()));
            System.out.printf("tot=%3.2fMp Kpps=%.2f(%.2fns) rate=%.2fMbps rm=%.2fMb available=%.2fMb(%.2fMb) %n", (double)this.total / 1000000.0, (double)this.count / d / 1000.0, d * 1.0E9 / (double)this.count, d3 / 1048576.0, d5 / 1048576.0, (double)JMemory.availableDirectMemory() / 1048576.0, (double)JMemory.maxDirectMemory() / 1048576.0);
            System.out.flush();
            this.ts = this.te;
            this.count = 0L;
            this.b = 0L;
            this.h = 0L;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        double d7 = (double)this.headers / 1000.0 / d;
        double d8 = 1.0E9 / ((double)this.headers / d);
        long l3 = (this.end - this.start) / 1000L;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L % 60L;
        long l6 = l3 / 3600L % 24L;
        System.out.printf("### %02d:%02d:%02d%n", l6, l5, l4);
        System.out.flush();
        linkedBlockingQueue.clear();
    }

    protected void runTest() throws Throwable {
        System.out.printf("============== %s ==============%n", this.getName());
        super.runTest();
    }
}

