/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.packet.JBinding;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderScanner;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.RegistryHeaderErrors;
import org.jnetpcap.packet.UnregisteredHeaderException;
import org.jnetpcap.packet.structure.AnnotatedBinding;
import org.jnetpcap.packet.structure.AnnotatedHeader;
import org.jnetpcap.packet.structure.AnnotatedScannerMethod;
import org.jnetpcap.packet.structure.HeaderDefinitionError;
import org.jnetpcap.protocol.JProtocol;
import org.jnetpcap.util.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRegistry {
    private static final int A_MAX_ID_COUNT = 256;
    public static final int CORE_ID_COUNT = 64;
    private static final int[] DLTS_TO_IDS;
    private static List<HeaderDefinitionError> errors;
    public static final int FLAG_HEURISTIC_BINDING = 16;
    public static final int FLAG_HEURISTIC_PRE_BINDING = 32;
    public static final int FLAG_OVERRIDE_BINDING = 2;
    public static final int FLAG_OVERRIDE_LENGTH = 1;
    private static final int[] headerFlags;
    private static final int[] IDS_TO_DLTS;
    private static int LAST_ID;
    private static final Entry[] MAP_BY_ID;
    private static Map<String, Entry> mapByClassName;
    private static Map<String, AnnotatedHeader> mapSubsByClassName;
    private static final int MAX_DLT_COUNT = 512;
    public static final int MAX_ID_COUNT = 256;
    public static final int NO_DLT_MAPPING = -1;
    private static final Map<Object, Resolver> resolvers;
    private static final JHeaderScanner[] scanners;

    public static void addBindings(Class<?> clazz) {
        JRegistry.clearErrors();
        if (JHeader.class.isAssignableFrom(clazz)) {
            JRegistry.addBindings(AnnotatedBinding.inspectJHeaderClass(clazz, errors));
        } else {
            JRegistry.addBindings(AnnotatedBinding.inspectClass(clazz, errors));
        }
    }

    public static void addBindings(JBinding ... jBindingArray) {
        for (JBinding jBinding : jBindingArray) {
            scanners[jBinding.getTargetId()].addBindings(jBinding);
        }
    }

    public static void addBindings(Object object) {
        if (object instanceof JBinding) {
            JRegistry.addBindings((JBinding)object);
            return;
        }
        JRegistry.clearErrors();
        JRegistry.addBindings(AnnotatedBinding.inspectObject(object, errors));
    }

    public static void clearErrors() {
        errors.clear();
    }

    public static void clearFlags(int n, int n2) {
        int n3 = n;
        headerFlags[n3] = headerFlags[n3] & ~n2;
    }

    public static void clearScanners(Class<? extends JHeader> ... classArray) {
        for (Class<? extends JHeader> clazz : classArray) {
            int n = JRegistry.lookupId(clazz);
            scanners[n].setScannerMethod(null);
        }
    }

    public static void clearScanners(int ... nArray) {
        for (int n : nArray) {
            scanners[n].setScannerMethod(null);
        }
    }

    public static void clearScanners(Object object) {
        AnnotatedScannerMethod[] annotatedScannerMethodArray = AnnotatedScannerMethod.inspectObject(object);
        int[] nArray = new int[annotatedScannerMethodArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = annotatedScannerMethodArray[i].getId();
        }
        JRegistry.clearScanners(nArray);
    }

    private static Entry createNewEntry(Class<? extends JHeader> clazz) {
        int n = LAST_ID++;
        Entry entry = new Entry(n, clazz);
        mapByClassName.put(clazz.getCanonicalName(), entry);
        JRegistry.MAP_BY_ID[n] = entry;
        return entry;
    }

    public static JBinding[] getBindings(int n) {
        return scanners[n].getBindings();
    }

    public static HeaderDefinitionError[] getErrors() {
        return errors.toArray(new HeaderDefinitionError[errors.size()]);
    }

    public static int getFlags(int n) {
        return headerFlags[n];
    }

    public static int[] getAllFlags() {
        int[] nArray = new int[headerFlags.length];
        System.arraycopy(headerFlags, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public static void setAllFlags(int[] nArray) {
        System.arraycopy(nArray, 0, headerFlags, 0, nArray.length);
    }

    public static JHeaderScanner[] getHeaderScanners() {
        JHeaderScanner[] jHeaderScannerArray = new JHeaderScanner[256];
        System.arraycopy(scanners, 0, jHeaderScannerArray, 0, 256);
        return jHeaderScannerArray;
    }

    public static Resolver getResolver(Object object) {
        Resolver resolver = resolvers.get(object);
        resolver.initializeIfNeeded();
        return resolver;
    }

    public static Resolver getResolver(Resolver.ResolverType resolverType) {
        return JRegistry.getResolver((Object)resolverType);
    }

    public static boolean hasDltMapping(int n) {
        return n >= 0 && n < DLTS_TO_IDS.length && DLTS_TO_IDS[n] != -1;
    }

    public static boolean hasErrors() {
        return errors.isEmpty();
    }

    public static boolean hasResolver(Object object) {
        return resolvers.containsKey(object);
    }

    public static boolean hasResolver(Resolver.ResolverType resolverType) {
        return resolvers.containsKey((Object)resolverType);
    }

    public static AnnotatedHeader inspect(Class<? extends JHeader> clazz, List<HeaderDefinitionError> list) {
        return AnnotatedHeader.inspectJHeaderClass(clazz, list);
    }

    public static Object[] listResolvers() {
        return resolvers.keySet().toArray(new Object[resolvers.size()]);
    }

    public static AnnotatedHeader lookupAnnotatedHeader(Class<? extends JHeader> clazz) throws UnregisteredHeaderException {
        if (JSubHeader.class.isAssignableFrom(clazz)) {
            return JRegistry.lookupAnnotatedSubHeader(clazz);
        }
        return JRegistry.lookupAnnotatedHeader(JRegistry.lookupIdNoCreate(clazz));
    }

    public static AnnotatedHeader lookupAnnotatedHeader(int n) throws UnregisteredHeaderException {
        if (MAP_BY_ID[n] == null || MAP_BY_ID[n].annotatedHeader == null) {
            throw new UnregisteredHeaderException("header [" + n + "] not registered");
        }
        return MAP_BY_ID[n].annotatedHeader;
    }

    public static AnnotatedHeader lookupAnnotatedHeader(JProtocol jProtocol) {
        Class<? extends JHeader> clazz = jProtocol.getHeaderClass();
        Entry entry = MAP_BY_ID[jProtocol.getId()];
        if (entry.annotatedHeader == null) {
            errors.clear();
            entry.annotatedHeader = JRegistry.inspect(clazz, JRegistry.errors);
            JRegistry.registerAnnotatedSubHeaders(entry.annotatedHeader.getHeaders());
        }
        return entry.annotatedHeader;
    }

    static AnnotatedHeader lookupAnnotatedSubHeader(Class<? extends JSubHeader<? extends JSubHeader<?>>> clazz) {
        if (!mapSubsByClassName.containsKey(clazz.getCanonicalName())) {
            throw new UnregisteredHeaderException("sub header [" + clazz.getName() + "] not registered, most likely parent not registered as well");
        }
        return mapSubsByClassName.get(clazz.getCanonicalName());
    }

    public static Class<? extends JHeader> lookupClass(int n) throws UnregisteredHeaderException {
        if (n > LAST_ID) {
            throw new UnregisteredHeaderException("invalid id " + n);
        }
        Entry entry = MAP_BY_ID[n];
        if (entry == null) {
            throw new UnregisteredHeaderException("invalid id " + n);
        }
        return entry.getHeaderClass();
    }

    public static int lookupId(Class<? extends JHeader> clazz) {
        if (JSubHeader.class.isAssignableFrom(clazz)) {
            AnnotatedHeader annotatedHeader = JRegistry.lookupAnnotatedSubHeader(clazz);
            return annotatedHeader.getId();
        }
        Entry entry = mapByClassName.get(clazz.getCanonicalName());
        if (entry == null) {
            entry = JRegistry.createNewEntry(clazz);
        }
        return entry.id;
    }

    public static int lookupId(JProtocol jProtocol) {
        return jProtocol.getId();
    }

    private static int lookupIdNoCreate(Class<? extends JHeader> clazz) throws UnregisteredHeaderException {
        if (!mapByClassName.containsKey(clazz.getCanonicalName())) {
            throw new UnregisteredHeaderException("header [" + clazz.getName() + "] not registered");
        }
        return mapByClassName.get(clazz.getCanonicalName()).id;
    }

    public static JHeaderScanner lookupScanner(int n) {
        return scanners[n];
    }

    public static int mapDLTToId(int n) {
        return DLTS_TO_IDS[n];
    }

    public static int mapIdToDLT(int n) {
        return IDS_TO_DLTS[n];
    }

    public static PcapDLT mapIdToPcapDLT(int n) {
        return PcapDLT.valueOf(IDS_TO_DLTS[n]);
    }

    public static int register(Class<? extends JHeader> clazz) throws RegistryHeaderErrors {
        ArrayList<HeaderDefinitionError> arrayList = new ArrayList<HeaderDefinitionError>();
        int n = JRegistry.register(clazz, arrayList);
        if (!arrayList.isEmpty()) {
            throw new RegistryHeaderErrors(clazz, arrayList, "while trying to register " + clazz.getSimpleName() + " class");
        }
        return n;
    }

    public static int register(Class<? extends JHeader> clazz, List<HeaderDefinitionError> list) {
        AnnotatedHeader annotatedHeader = JRegistry.inspect(clazz, list);
        if (!list.isEmpty()) {
            return -1;
        }
        Entry entry = mapByClassName.get(clazz.getCanonicalName());
        if (entry == null) {
            entry = JRegistry.createNewEntry(clazz);
        }
        int n = entry.id;
        entry.annotatedHeader = annotatedHeader;
        JRegistry.scanners[n] = new JHeaderScanner(clazz);
        JRegistry.registerAnnotatedSubHeaders(annotatedHeader.getHeaders());
        JBinding[] jBindingArray = AnnotatedBinding.inspectJHeaderClass(clazz, list);
        if (!list.isEmpty()) {
            return -1;
        }
        JRegistry.addBindings(jBindingArray);
        for (PcapDLT pcapDLT : annotatedHeader.getDlt()) {
            JRegistry.registerDLT(pcapDLT, n);
        }
        return n;
    }

    static int register(JProtocol jProtocol) {
        Entry entry = new Entry(jProtocol.getId(), jProtocol.getHeaderClassName());
        mapByClassName.put(jProtocol.getHeaderClassName(), entry);
        if (MAP_BY_ID[jProtocol.getId()] != null) {
            throw new IllegalStateException("protocol already registred? " + jProtocol.getId());
        }
        JRegistry.MAP_BY_ID[jProtocol.getId()] = entry;
        try {
            JRegistry.scanners[jProtocol.getId()] = new JHeaderScanner(jProtocol);
        }
        catch (UnregisteredHeaderException unregisteredHeaderException) {
            JRegistry.register(jProtocol.getClazz(), errors);
        }
        for (PcapDLT pcapDLT : jProtocol.getDlt()) {
            JRegistry.registerDLT(pcapDLT, jProtocol.getId());
        }
        return jProtocol.getId();
    }

    private static void registerAnnotatedSubHeaders(AnnotatedHeader[] annotatedHeaderArray) {
        for (AnnotatedHeader annotatedHeader : annotatedHeaderArray) {
            mapSubsByClassName.put(annotatedHeader.getHeaderClass().getCanonicalName(), annotatedHeader);
            JRegistry.registerAnnotatedSubHeaders(annotatedHeader.getHeaders());
        }
    }

    public static void registerDLT(int n, int n2) {
        JRegistry.DLTS_TO_IDS[n] = n2;
        JRegistry.IDS_TO_DLTS[n2] = n;
    }

    public static void registerDLT(PcapDLT pcapDLT, int n) {
        JRegistry.registerDLT(pcapDLT.getValue(), n);
    }

    public static void registerResolver(Object object, Resolver resolver) {
        resolvers.put(object, resolver);
    }

    public static void registerResolver(Resolver.ResolverType resolverType, Resolver resolver) {
        resolvers.put((Object)resolverType, resolver);
    }

    public static void resetBindings(int n) {
        scanners[n].clearBindings();
    }

    public static void setFlags(int n, int n2) {
        int n3 = n;
        headerFlags[n3] = headerFlags[n3] | n2;
    }

    public static void setScanners(AnnotatedScannerMethod ... annotatedScannerMethodArray) {
        for (AnnotatedScannerMethod annotatedScannerMethod : annotatedScannerMethodArray) {
            JHeaderScanner jHeaderScanner = scanners[annotatedScannerMethod.getId()];
            jHeaderScanner.setScannerMethod(annotatedScannerMethod);
        }
    }

    public static void setScanners(Class<?> clazz) {
        if (JHeader.class.isAssignableFrom(clazz)) {
            JRegistry.setScanners(AnnotatedScannerMethod.inspectJHeaderClass(clazz));
        } else {
            JRegistry.setScanners(AnnotatedScannerMethod.inspectClass(clazz));
        }
    }

    public static void setScanners(Object object) {
        AnnotatedScannerMethod[] annotatedScannerMethodArray = AnnotatedScannerMethod.inspectObject(object);
        JRegistry.setScanners(annotatedScannerMethodArray);
    }

    public static void shutdown() throws IOException {
        for (Resolver resolver : resolvers.values()) {
            if (resolver == null) continue;
            resolver.saveCache();
        }
        resolvers.clear();
    }

    public static String toDebugString() {
        Object object;
        Formatter formatter = new Formatter();
        try {
            int n;
            for (n = 0; n < 256; ++n) {
                if (scanners[n] == null) continue;
                formatter.format("scanner[%-2d] class=%-15s %s\n", n, JRegistry.lookupClass(n).getSimpleName(), scanners[n].toString());
            }
            for (n = 0; n < 512; ++n) {
                if (!JRegistry.hasDltMapping(n)) continue;
                int n2 = JRegistry.mapDLTToId(n);
                object = JRegistry.lookupClass(n2);
                if (PcapDLT.valueOf(n) != null) {
                    formatter.format("libpcap::%-24s => header::%s.class(%d)\n", PcapDLT.valueOf(n).toString() + "(" + n + ")", ((Class)object).getSimpleName(), n2);
                    continue;
                }
                formatter.format("libpcap::%-24d => header::%s.class(%d)\n", n, ((Class)object).getSimpleName(), n2);
            }
        }
        catch (UnregisteredHeaderException unregisteredHeaderException) {
            throw new IllegalStateException(unregisteredHeaderException);
        }
        for (Object object2 : resolvers.keySet()) {
            object = resolvers.get(object2);
            object.initializeIfNeeded();
            formatter.format("Resolver %s: %s\n", String.valueOf(object2), object.toString());
        }
        return formatter.toString();
    }

    private JRegistry() {
    }

    static {
        errors = new ArrayList<HeaderDefinitionError>();
        headerFlags = new int[256];
        LAST_ID = 64;
        MAP_BY_ID = new Entry[256];
        mapByClassName = new HashMap<String, Entry>();
        mapSubsByClassName = new HashMap<String, AnnotatedHeader>(50);
        resolvers = new HashMap<Object, Resolver>();
        scanners = new JHeaderScanner[256];
        DLTS_TO_IDS = new int[512];
        IDS_TO_DLTS = new int[256];
        Arrays.fill(DLTS_TO_IDS, -1);
        Arrays.fill(IDS_TO_DLTS, -1);
        for (JProtocol enum_ : JProtocol.values()) {
            try {
                JRegistry.register(enum_);
            }
            catch (Exception exception) {
                System.err.println("JRegistry Error: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(0);
            }
        }
        for (JProtocol jProtocol : JProtocol.values()) {
            try {
                JBinding[] jBindingArray = AnnotatedBinding.inspectJHeaderClass(jProtocol.getHeaderClass(), errors);
                if (jBindingArray == null || jBindingArray.length == 0) continue;
                JRegistry.addBindings(jBindingArray);
            }
            catch (Exception exception) {
                System.err.println("JRegistry Error: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(0);
            }
        }
        for (Enum enum_ : Resolver.ResolverType.values()) {
            if (((Resolver.ResolverType)enum_).getResolver() == null) continue;
            try {
                JRegistry.registerResolver((Resolver.ResolverType)enum_, ((Resolver.ResolverType)enum_).getResolver());
            }
            catch (Exception exception) {
                System.err.println("JRegistry Error: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(0);
            }
        }
        JRegistry.setFlags(4, 16);
        JRegistry.setFlags(5, 16);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private AnnotatedHeader annotatedHeader;
        private final String className;
        private Class<? extends JHeader> clazz;
        private final int id;

        public Entry(int n, Class<? extends JHeader> clazz) {
            this.id = n;
            this.clazz = clazz;
            this.className = clazz.getName();
        }

        public Entry(int n, String string) {
            this.id = n;
            this.className = string;
        }

        public Class<? extends JHeader> getHeaderClass() {
            if (this.clazz == null) {
                try {
                    return Class.forName(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException);
                }
            }
            return this.clazz;
        }
    }
}

