/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.header;

import java.io.IOException;
import junit.framework.TestCase;
import org.jnetpcap.packet.Payload;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.protocol.network.Icmp;
import org.jnetpcap.protocol.network.Ip4;

public class TestIcmp
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIcmpDestUnreachable() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-afs.pcap", 28);
        System.out.println(pcapPacket.toHexdump(128, false, false, true));
        System.out.println(pcapPacket.getState().toDebugString());
        Ip4 ip4 = new Ip4();
        Icmp icmp = new Icmp();
        Icmp.DestinationUnreachable destinationUnreachable = new Icmp.DestinationUnreachable();
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(2, 0));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(icmp));
        TestIcmp.assertTrue((boolean)icmp.hasSubHeader(Icmp.IcmpType.DESTINATION_UNREACHABLE.getId()));
        TestIcmp.assertTrue((boolean)icmp.hasSubHeader(destinationUnreachable));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(ip4, 1));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(5));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(Payload.ID));
        TestIcmp.assertEquals((int)3, (int)icmp.type());
        TestIcmp.assertEquals((int)3, (int)icmp.code());
        TestIcmp.assertEquals((int)10033, (int)icmp.checksum());
        TestIcmp.assertEquals((long)0L, (long)destinationUnreachable.reserved());
        TestIcmp.assertEquals((int)34596, (int)ip4.checksum());
        TestIcmp.assertEquals((int)440, (int)ip4.length());
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.ECHO_REPLY.getId()));
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.PARAM_PROBLEM.getId()));
    }

    public void testIcmpEchoRequest() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-vlan.pcap", 57);
        System.out.println(pcapPacket.toString());
        Icmp icmp = new Icmp();
        Icmp.EchoRequest echoRequest = new Icmp.EchoRequest();
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(9, 0));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(2));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(icmp));
        TestIcmp.assertTrue((boolean)icmp.hasSubHeader(echoRequest));
        TestIcmp.assertEquals((int)8, (int)icmp.type());
        TestIcmp.assertEquals((int)0, (int)icmp.code());
        TestIcmp.assertEquals((int)4349, (int)icmp.checksum());
        TestIcmp.assertEquals((int)53249, (int)echoRequest.id());
        TestIcmp.assertEquals((int)33054, (int)echoRequest.sequence());
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.ECHO_REPLY.id));
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.PARAM_PROBLEM.id));
    }

    public void testIcmpEchoReply() throws IOException {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-vlan.pcap", 58);
        Icmp icmp = new Icmp();
        Icmp.EchoReply echoReply = new Icmp.EchoReply();
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(1));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(9, 0));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(2));
        TestIcmp.assertTrue((boolean)pcapPacket.hasHeader(icmp));
        TestIcmp.assertTrue((boolean)icmp.hasSubHeader(echoReply));
        TextFormatter textFormatter = new TextFormatter();
        TestIcmp.assertEquals((int)0, (int)icmp.type());
        TestIcmp.assertEquals((int)0, (int)icmp.code());
        TestIcmp.assertEquals((int)6397, (int)icmp.checksum());
        TestIcmp.assertEquals((int)53249, (int)echoReply.id());
        TestIcmp.assertEquals((int)33054, (int)echoReply.sequence());
        TestIcmp.assertTrue((boolean)icmp.hasSubHeader(Icmp.IcmpType.ECHO_REPLY.id));
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.ECHO_REQUEST.id));
        TestIcmp.assertFalse((boolean)icmp.hasSubHeader(Icmp.IcmpType.PARAM_PROBLEM.id));
    }
}

