/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import org.jnetpcap.Pcap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PcapTask<T>
implements Runnable {
    protected int result = 0;
    protected Thread thread;
    protected final Pcap pcap;
    protected final int count;
    protected final T user;

    public PcapTask(Pcap pcap, int n, T t) {
        this.pcap = pcap;
        this.count = n;
        this.user = t;
    }

    public final int getResult() {
        return this.result;
    }

    public final Thread getThread() {
        return this.thread;
    }

    public void start() throws InterruptedException {
        if (this.thread != null) {
            this.stop();
        }
        this.thread = new Thread(new Runnable(){

            public void run() {
                PcapTask.this.run();
                PcapTask.this.thread = null;
            }
        }, this.user != null ? this.user.toString() : this.pcap.toString());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws InterruptedException {
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        this.breakLoop();
        this.thread.join();
    }

    protected void breakLoop() {
        this.pcap.breakloop();
    }

    public boolean isAlive() {
        return this.thread != null && this.thread.isAlive();
    }

    public final Pcap getPcap() {
        return this.pcap;
    }

    public final int getCount() {
        return this.count;
    }

    public final T getUser() {
        return this.user;
    }
}

