/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpTrafficGenerator
implements Runnable {
    private static final long SLEEP = 100L;
    private long timeout = 5000L;
    private final AtomicBoolean runflag = new AtomicBoolean(false);
    private final Thread worker;
    private URL website;

    public HttpTrafficGenerator(long l, URL uRL) {
        this.timeout = l;
        this.website = uRL;
        this.worker = new Thread((Runnable)this, "HttpTrafficGenerator");
    }

    public HttpTrafficGenerator(long l) {
        this.timeout = l;
        this.worker = new Thread((Runnable)this, "HttpTrafficGenerator");
        try {
            this.website = new URL("http://google.com");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Internal error", malformedURLException);
        }
    }

    public HttpTrafficGenerator() {
        this.worker = new Thread((Runnable)this, "HttpTrafficGenerator");
        try {
            this.website = new URL("http://google.com");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Internal error", malformedURLException);
        }
    }

    public void start() {
        if (this.worker.isAlive()) {
            throw new IllegalStateException("Worker thread is still alive, unexpected.");
        }
        if (this.runflag.get()) {
            throw new IllegalStateException("Runflag is inconsistant with thread, unexpected.");
        }
        this.runflag.set(true);
        this.worker.start();
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        int n = 0;
        while (this.runflag.get()) {
            try {
                Object object = this.website.getContent();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break;
            }
            if (System.currentTimeMillis() - l > this.timeout) break;
            ++n;
        }
        this.runflag.set(false);
    }

    public void stop() {
        this.runflag.set(false);
        while (this.worker.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

