/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelVauEpaFacet
implements RbelFacet {
    private final RbelElement message;
    private final RbelElement encryptedMessage;
    private final RbelElement sequenceNumber;
    private final RbelElement additionalHeaders;
    private final RbelElement pVersionNumber;
    private final RbelElement keyIdUsed;

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        return Stream.of(Pair.of("message", this.message), Pair.of("encryptedMessage", this.encryptedMessage), Pair.of("sequenceNumber", this.sequenceNumber), Pair.of("additionalHeaders", this.additionalHeaders), Pair.of("pVersionNumber", this.pVersionNumber), Pair.of("keyId", this.keyIdUsed)).filter(pair -> pair.getValue() != null).collect(Collectors.toList());
    }

    @Generated
    public static RbelVauEpaFacetBuilder builder() {
        return new RbelVauEpaFacetBuilder();
    }

    @ConstructorProperties(value={"message", "encryptedMessage", "sequenceNumber", "additionalHeaders", "pVersionNumber", "keyIdUsed"})
    @Generated
    public RbelVauEpaFacet(RbelElement message, RbelElement encryptedMessage, RbelElement sequenceNumber, RbelElement additionalHeaders, RbelElement pVersionNumber, RbelElement keyIdUsed) {
        this.message = message;
        this.encryptedMessage = encryptedMessage;
        this.sequenceNumber = sequenceNumber;
        this.additionalHeaders = additionalHeaders;
        this.pVersionNumber = pVersionNumber;
        this.keyIdUsed = keyIdUsed;
    }

    @Generated
    public RbelElement getMessage() {
        return this.message;
    }

    @Generated
    public RbelElement getEncryptedMessage() {
        return this.encryptedMessage;
    }

    @Generated
    public RbelElement getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public RbelElement getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    @Generated
    public RbelElement getPVersionNumber() {
        return this.pVersionNumber;
    }

    @Generated
    public RbelElement getKeyIdUsed() {
        return this.keyIdUsed;
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelVauEpaFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return TagCreator.div(RbelHtmlRenderingToolkit.t1ms("VAU Encrypted Message (EPA)").with(RbelHtmlRenderer.showContentButtonAndDialog(element)), RbelHtmlRenderingToolkit.addNote(element, "mb-5"), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(RbelHtmlRenderingToolkit.childBoxNotifTitle("is-info").with(RbelHtmlRenderingToolkit.t2("Header"), Optional.ofNullable(element.getFacetOrFail(RbelVauEpaFacet.class)).map(RbelVauEpaFacet::getAdditionalHeaders).map(headers -> renderingToolkit.convert((RbelElement)headers)).orElse(TagCreator.span()), Optional.ofNullable(element.getFacetOrFail(RbelVauEpaFacet.class).getPVersionNumber()).map(v -> TagCreator.p(TagCreator.b("Version Number: ")).withText(v.seekValue().get().toString())).orElse(TagCreator.span()), Optional.ofNullable(element.getFacetOrFail(RbelVauEpaFacet.class).getSequenceNumber()).map(v -> TagCreator.p(TagCreator.b("Sequence Number: ")).withText(v.seekValue().get().toString())).orElse(TagCreator.span())), RbelHtmlRenderingToolkit.childBoxNotifTitle("is-info").with(RbelHtmlRenderingToolkit.t2("Body"), RbelHtmlRenderingToolkit.addNote(element.getFacetOrFail(RbelVauEpaFacet.class).getMessage(), new String[0]), renderingToolkit.convert(element.getFacetOrFail(RbelVauEpaFacet.class).getMessage())), RbelHtmlRenderingToolkit.childBoxNotifTitle("is-success").with(((ContainerTag)TagCreator.p().withClass("is-success")).withText("Was decrypted using Key ").with((DomContent)TagCreator.b(element.getFacetOrFail(RbelVauEpaFacet.class).getKeyIdUsed().getRawStringContent())), RbelHtmlRenderingToolkit.addNote(element, new String[0])))));
            }
        });
    }

    @Generated
    public static class RbelVauEpaFacetBuilder {
        @Generated
        private RbelElement message;
        @Generated
        private RbelElement encryptedMessage;
        @Generated
        private RbelElement sequenceNumber;
        @Generated
        private RbelElement additionalHeaders;
        @Generated
        private RbelElement pVersionNumber;
        @Generated
        private RbelElement keyIdUsed;

        @Generated
        RbelVauEpaFacetBuilder() {
        }

        @Generated
        public RbelVauEpaFacetBuilder message(RbelElement message) {
            this.message = message;
            return this;
        }

        @Generated
        public RbelVauEpaFacetBuilder encryptedMessage(RbelElement encryptedMessage) {
            this.encryptedMessage = encryptedMessage;
            return this;
        }

        @Generated
        public RbelVauEpaFacetBuilder sequenceNumber(RbelElement sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public RbelVauEpaFacetBuilder additionalHeaders(RbelElement additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        @Generated
        public RbelVauEpaFacetBuilder pVersionNumber(RbelElement pVersionNumber) {
            this.pVersionNumber = pVersionNumber;
            return this;
        }

        @Generated
        public RbelVauEpaFacetBuilder keyIdUsed(RbelElement keyIdUsed) {
            this.keyIdUsed = keyIdUsed;
            return this;
        }

        @Generated
        public RbelVauEpaFacet build() {
            return new RbelVauEpaFacet(this.message, this.encryptedMessage, this.sequenceNumber, this.additionalHeaders, this.pVersionNumber, this.keyIdUsed);
        }

        @Generated
        public String toString() {
            return "RbelVauEpaFacet.RbelVauEpaFacetBuilder(message=" + this.message + ", encryptedMessage=" + this.encryptedMessage + ", sequenceNumber=" + this.sequenceNumber + ", additionalHeaders=" + this.additionalHeaders + ", pVersionNumber=" + this.pVersionNumber + ", keyIdUsed=" + this.keyIdUsed + ")";
        }
    }
}

