/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelBase64JsonConverter;
import de.gematik.rbellogger.converter.RbelBearerTokenConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelErpVauDecrpytionConverter;
import de.gematik.rbellogger.converter.RbelHttpFormDataConverter;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.converter.RbelJweConverter;
import de.gematik.rbellogger.converter.RbelJwtConverter;
import de.gematik.rbellogger.converter.RbelMtomConverter;
import de.gematik.rbellogger.converter.RbelUriConverter;
import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.converter.RbelVauEpaConverter;
import de.gematik.rbellogger.converter.RbelVauKeyDeriver;
import de.gematik.rbellogger.converter.RbelXmlConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.key.RbelKeyManager;
import java.beans.ConstructorProperties;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelConverter.class);
    private final List<RbelElement> messageHistory = new ArrayList<RbelElement>();
    private final RbelKeyManager rbelKeyManager;
    private final RbelValueShader rbelValueShader = new RbelValueShader();
    private final List<RbelConverterPlugin> postConversionListeners = new ArrayList<RbelConverterPlugin>();
    private final Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> preConversionMappers = new HashMap<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>>();
    private final List<RbelConverterPlugin> converterPlugins = new ArrayList<RbelConverterPlugin>(List.of(new RbelBase64JsonConverter(), new RbelHttpResponseConverter(), new RbelHttpRequestConverter(), new RbelJwtConverter(), new RbelHttpFormDataConverter(), new RbelJweConverter(), new RbelErpVauDecrpytionConverter(), new RbelUriConverter(), new RbelBearerTokenConverter(), new RbelVauEpaConverter(), new RbelXmlConverter(), new RbelJsonConverter(), new RbelVauKeyDeriver(), new RbelMtomConverter()));
    private long messageSequenceNumber;

    public RbelElement convertElement(byte[] input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input).build());
    }

    public RbelElement convertElement(String input, RbelElement parentNode) {
        return this.convertElement(RbelElement.builder().parentNode(parentNode).rawContent(input.getBytes()).build());
    }

    public RbelElement convertElement(RbelElement rawInput) {
        log.trace("Converting {}...", (Object)rawInput);
        RbelElement convertedInput = this.filterInputThroughPreConversionMappers(rawInput);
        for (RbelConverterPlugin plugin : this.converterPlugins) {
            plugin.consumeElement(convertedInput, this);
        }
        return convertedInput;
    }

    private RbelElement findLastRequest() {
        List<RbelElement> messageHistory = this.getMessageHistory();
        for (int i = messageHistory.size() - 1; i >= 0; --i) {
            if (!this.messageHistory.get(i).getFacet(RbelHttpRequestFacet.class).isPresent()) continue;
            return this.messageHistory.get(i);
        }
        return null;
    }

    public RbelElement filterInputThroughPreConversionMappers(RbelElement input) {
        RbelElement value = input;
        for (BiFunction mapper : this.preConversionMappers.entrySet().stream().filter(entry -> input.getClass().isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList())) {
            RbelElement newValue = (RbelElement)mapper.apply(value, this);
            if (newValue != value) {
                value = this.filterInputThroughPreConversionMappers(newValue);
                continue;
            }
            value = newValue;
        }
        return value;
    }

    public void registerListener(RbelConverterPlugin listener) {
        this.postConversionListeners.add(listener);
    }

    public void triggerPostConversionListenerFor(RbelElement element) {
        for (RbelConverterPlugin postConversionListener : this.postConversionListeners) {
            postConversionListener.consumeElement(element, this);
        }
    }

    public void registerMapper(Class<? extends RbelElement> clazz, BiFunction<RbelElement, RbelConverter, RbelElement> mapper) {
        this.preConversionMappers.computeIfAbsent(clazz, key -> new ArrayList()).add(mapper);
    }

    public void addConverter(RbelConverterPlugin converter) {
        this.converterPlugins.add(converter);
    }

    public RbelElement parseMessage(byte[] content, RbelHostname sender, RbelHostname recipient) {
        RbelElement rbelHttpMessage = this.convertElement(content, null);
        return this.parseMessage(rbelHttpMessage, sender, recipient);
    }

    public RbelElement parseMessage(RbelElement rbelElement, RbelHostname sender, RbelHostname receiver) {
        if (rbelElement.getFacet(RbelHttpResponseFacet.class).isEmpty() && rbelElement.getFacet(RbelHttpRequestFacet.class).isEmpty()) {
            throw new RbelConversionException("Illegal type encountered: Content of http-Message was parsed as " + rbelElement.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toList()) + ". Expected RbelHttpMessage (Rbel can only handle HTTP messages right now)");
        }
        if (rbelElement.getFacet(RbelHttpResponseFacet.class).isPresent()) {
            RbelElement lastRequest = this.findLastRequest();
            if (lastRequest != null) {
                rbelElement.addOrReplaceFacet(rbelElement.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(lastRequest).build());
            }
            rbelElement.addOrReplaceFacet(rbelElement.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(lastRequest).build());
        }
        rbelElement.addFacet(RbelTcpIpMessageFacet.builder().receiver(RbelElement.wrap(null, rbelElement, receiver)).sender(RbelElement.wrap(null, rbelElement, sender)).sequenceNumber(this.messageSequenceNumber++).build());
        rbelElement.triggerPostConversionListener(this);
        this.messageHistory.add(rbelElement);
        return rbelElement;
    }

    public RbelConverter addPostConversionListener(RbelConverterPlugin postConversionListener) {
        this.postConversionListeners.add(postConversionListener);
        return this;
    }

    public void removeAllConverterPlugins() {
        this.converterPlugins.clear();
    }

    @Generated
    private static long $default$messageSequenceNumber() {
        return 0L;
    }

    @Generated
    public static RbelConverterBuilder builder() {
        return new RbelConverterBuilder();
    }

    @ConstructorProperties(value={"rbelKeyManager", "messageSequenceNumber"})
    @Generated
    private RbelConverter(RbelKeyManager rbelKeyManager, long messageSequenceNumber) {
        Security.addProvider(new BouncyCastleProvider());
        this.rbelKeyManager = rbelKeyManager;
        this.messageSequenceNumber = messageSequenceNumber;
    }

    @Generated
    public List<RbelElement> getMessageHistory() {
        return this.messageHistory;
    }

    @Generated
    public RbelKeyManager getRbelKeyManager() {
        return this.rbelKeyManager;
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public List<RbelConverterPlugin> getPostConversionListeners() {
        return this.postConversionListeners;
    }

    @Generated
    public Map<Class<? extends RbelElement>, List<BiFunction<RbelElement, RbelConverter, RbelElement>>> getPreConversionMappers() {
        return this.preConversionMappers;
    }

    @Generated
    public List<RbelConverterPlugin> getConverterPlugins() {
        return this.converterPlugins;
    }

    @Generated
    public long getMessageSequenceNumber() {
        return this.messageSequenceNumber;
    }

    @Generated
    public static class RbelConverterBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private boolean messageSequenceNumber$set;
        @Generated
        private long messageSequenceNumber$value;

        @Generated
        RbelConverterBuilder() {
        }

        @Generated
        public RbelConverterBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelConverterBuilder messageSequenceNumber(long messageSequenceNumber) {
            this.messageSequenceNumber$value = messageSequenceNumber;
            this.messageSequenceNumber$set = true;
            return this;
        }

        @Generated
        public RbelConverter build() {
            long messageSequenceNumber$value = this.messageSequenceNumber$value;
            if (!this.messageSequenceNumber$set) {
                messageSequenceNumber$value = RbelConverter.$default$messageSequenceNumber();
            }
            return new RbelConverter(this.rbelKeyManager, messageSequenceNumber$value);
        }

        @Generated
        public String toString() {
            return "RbelConverter.RbelConverterBuilder(rbelKeyManager=" + this.rbelKeyManager + ", messageSequenceNumber$value=" + this.messageSequenceNumber$value + ")";
        }
    }
}

