/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter.initializers;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.key.RbelKey;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RbelKeyFolderInitializer
implements Consumer<RbelConverter> {
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();
    private final String keyFolderPath;

    @Override
    public void accept(RbelConverter rbelConverter) {
        try (Stream<Path> fileStream = Files.walk(Path.of(this.keyFolderPath, new String[0]), new FileVisitOption[0]);){
            fileStream.map(Path::toFile).filter(File::isFile).filter(File::canRead).filter(file -> file.getName().endsWith(".p12")).map(this::readFileToKeyList).flatMap(Collection::stream).forEach(rbelConverter.getRbelKeyManager()::addKey);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while initializing keys", e);
        }
    }

    private List<RbelKey> readFileToKeyList(File file) {
        try {
            return RbelKeyFolderInitializer.getIdentityFromP12(FileUtils.readFileToByteArray((File)file), file.getName().replace(".p12", ""));
        }
        catch (IOException e) {
            return List.of();
        }
    }

    private static List<RbelKey> getIdentityFromP12(byte[] p12FileContent, String fileName) {
        try {
            KeyStore p12 = KeyStore.getInstance("pkcs12", (Provider)BOUNCY_CASTLE_PROVIDER);
            p12.load(new ByteArrayInputStream(p12FileContent), "00".toCharArray());
            Enumeration<String> e = p12.aliases();
            if (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate certificate = (X509Certificate)p12.getCertificate(alias);
                PrivateKey privateKey = (PrivateKey)p12.getKey(alias, "00".toCharArray());
                RbelKey rbelPublicKey = new RbelKey(certificate.getPublicKey(), "puk_" + fileName, 110);
                return List.of(rbelPublicKey, new RbelKey((Key)privateKey, "prk_" + fileName, 110, rbelPublicKey));
            }
            return List.of();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            return List.of();
        }
    }

    @ConstructorProperties(value={"keyFolderPath"})
    @Generated
    public RbelKeyFolderInitializer(String keyFolderPath) {
        this.keyFolderPath = keyFolderPath;
    }
}

