/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelHttpResponseConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.util.RbelArrayUtils;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class RbelHttpRequestConverter
extends RbelHttpResponseConverter {
    @Override
    public void consumeElement(RbelElement rbel, RbelConverter converter) {
        String content = rbel.getRawStringContent();
        if (StringUtils.isEmpty((CharSequence)content) || !content.contains("\n")) {
            return;
        }
        String eol = RbelHttpRequestConverter.findEolInHttpMessage(content);
        if (content.split(eol).length == 0) {
            return;
        }
        String firstLine = content.split(eol)[0].trim();
        if (!((firstLine.startsWith("GET ") || firstLine.startsWith("POST ") || firstLine.startsWith("PUT ") || firstLine.startsWith("DELETE ")) && (firstLine.endsWith("HTTP/1.0") || firstLine.endsWith("HTTP/1.1") || firstLine.endsWith("HTTP/2.0")))) {
            return;
        }
        String messageHeader = content.split(eol + eol)[0];
        int space = messageHeader.indexOf(" ");
        int space2 = messageHeader.indexOf(" ", space + 1);
        String method = messageHeader.substring(0, space);
        String path = messageHeader.substring(space + 1, space2);
        RbelElement headerElement = this.extractHeaderFromMessage(rbel, converter, eol);
        RbelElement pathElement = converter.convertElement(path, rbel);
        if (!pathElement.hasFacet(RbelUriFacet.class)) {
            throw new RuntimeException("Encountered ill-formatted path: " + path);
        }
        byte[] bodyData = this.extractBodyData(rbel.getRawContent(), messageHeader.length() + 4, headerElement.getFacetOrFail(RbelHttpHeaderFacet.class), eol);
        RbelElement bodyElement = new RbelElement(bodyData, rbel);
        RbelHttpRequestFacet httpRequest = RbelHttpRequestFacet.builder().method(converter.convertElement(method, rbel)).path(pathElement).build();
        rbel.addFacet(httpRequest);
        rbel.addFacet(RbelHttpMessageFacet.builder().header(headerElement).body(bodyElement).build());
        converter.convertElement(bodyElement);
    }

    public static String findEolInHttpMessage(String content) {
        if (content.contains("\r\n") && content.indexOf("\r\n") < content.indexOf("\n")) {
            return "\r\n";
        }
        return "\n";
    }

    private byte[] extractBodyData(byte[] inputData, int separator, RbelHttpHeaderFacet headerMap, String eol) {
        if (headerMap.hasValueMatching("Transfer-Encoding", "chunked")) {
            separator = new String(inputData).indexOf(eol, separator) + eol.length();
            return Arrays.copyOfRange(inputData, separator, RbelArrayUtils.indexOf(inputData, ("0" + eol).getBytes(), separator));
        }
        return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), inputData.length);
    }
}

