/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RbelUriConverter
implements RbelConverterPlugin {
    public List<RbelElement> extractParameterMap(URI uri, RbelConverter context, String originalContent, RbelElement parentNode) {
        if (uri.getQuery() == null) {
            return List.of();
        }
        Map rawStringMap = Stream.of(originalContent.split("\\?")[1].split("\\&")).filter(StringUtils::isNotEmpty).collect(Collectors.toMap(param -> param.split("\\=")[0], Function.identity()));
        return Stream.of(uri.getQuery().split("&")).filter(param -> param.contains("=")).map(param -> param.split("=", 2)).map(array -> {
            RbelElement paramPair = new RbelElement(((String)rawStringMap.get(array[0])).getBytes(), parentNode);
            paramPair.addFacet(RbelUriParameterFacet.builder().key(RbelElement.wrap(paramPair, array[0])).value(context.convertElement(array[1].getBytes(), paramPair)).build());
            return paramPair;
        }).collect(Collectors.toList());
    }

    public boolean canConvertElement(RbelElement rbel) {
        try {
            URI uri = new URI(rbel.getRawStringContent());
            boolean hasQuery = uri.getQuery() != null;
            boolean hasProtocol = uri.getScheme() != null;
            return hasQuery || hasProtocol || rbel.getRawStringContent().startsWith("/");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        if (!this.canConvertElement(rbel)) {
            return;
        }
        URI uri = this.convertToUri(rbel);
        String[] pathParts = rbel.getRawStringContent().split("\\?", 2);
        RbelUriFacet.RbelUriFacetBuilder uriFacetBuilder = RbelUriFacet.builder().basicPath(RbelElement.wrap(rbel, pathParts[0]));
        if (pathParts.length > 1) {
            uriFacetBuilder.queryParameters(this.extractParameterMap(uri, context, rbel.getRawStringContent(), rbel));
        } else {
            uriFacetBuilder.queryParameters(List.of());
        }
        rbel.addFacet(uriFacetBuilder.build());
    }

    private URI convertToUri(RbelElement target) {
        try {
            return new URI(target.getRawStringContent());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to convert Path-Element", e);
        }
    }
}

