/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.aaa;

import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.RegistryHeaderErrors;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.protocol.sigtran.Sctp;
import org.jnetpcap.protocol.sigtran.SctpData;
import org.jnetpcap.protocol.tcpip.Tcp;
import org.jnetpcap.util.JThreadLocal;

@Header(length=20)
public class Diameter
extends JHeaderMap<Diameter> {
    public static int ID;
    private static final JThreadLocal<Sctp> local;

    @Bind(to=Tcp.class)
    public static boolean bindToTcp(JPacket jPacket, Tcp tcp) {
        return tcp.destination() == 3868 || tcp.source() == 3868;
    }

    @Bind(to=SctpData.class)
    public static boolean bindToTcp(JPacket jPacket, SctpData sctpData) {
        Sctp sctp = (Sctp)local.get();
        return jPacket.hasHeader(sctp) && (sctp.destination() == 3868 || sctp.source() == 3868);
    }

    @Field(offset=0, length=8, format="%d", display="version")
    public int getVersion() {
        return super.getUByte(0);
    }

    @Field(offset=8, length=24, format="%d", display="length")
    public int getMessageLength() {
        return (int)super.getUInt(0) & 0xFFFFFF;
    }

    @Field(offset=32, length=8, format="%x", display="flags")
    public int getCommandFlags() {
        return super.getUByte(4);
    }

    @Field(offset=40, length=24, format="%x", display="code")
    public int getCommandCode() {
        return (int)super.getUInt(4) & 0xFFFFFF;
    }

    @Field(offset=64, length=32, format="%d", display="Application-ID")
    public int applicationID() {
        return (int)super.getUInt(8);
    }

    @Field(offset=96, length=32, format="%x", display="Hop-by-Hop Identifier")
    public int getHopByHopIdentifier() {
        return super.getInt(12);
    }

    @Field(offset=128, length=32, format="%x", display="End-to-End Identifier")
    public int getEndToEndIdentifier() {
        return super.getInt(16);
    }

    static {
        try {
            ID = JRegistry.register(Diameter.class);
        }
        catch (RegistryHeaderErrors registryHeaderErrors) {
            registryHeaderErrors.printStackTrace();
        }
        local = new JThreadLocal<Sctp>(Sctp.class);
    }
}

