/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.jnetpcap.JCaptureHeader;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.PcapDumper;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.VariousInMemoryPackets;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestPcapDumper
extends TestCase {
    private PcapDumper dumper;
    private Pcap pcap;
    private File file;
    private static final byte[] data = VariousInMemoryPackets.PACKET_1;
    private static final int fileLength = 40 + data.length;
    private int useconds;
    private long seconds;
    private int wirelen;

    @Before
    public void setUp() throws IOException {
        this.file = File.createTempFile("TestPcapDumperJUnitTestCases", "");
        this.pcap = Pcap.openDead(PcapDLT.EN10MB.value, 65536);
        this.dumper = this.pcap.dumpOpen(this.file.getCanonicalPath());
        this.seconds = System.currentTimeMillis() / 1000L;
        this.useconds = (int)(System.currentTimeMillis() % 1000L) * 1000;
        this.wirelen = data.length;
    }

    @After
    public void tearDown() {
        if (this.dumper != null) {
            this.dumper.close();
            this.dumper = null;
        }
        if (this.pcap != null) {
            this.pcap.close();
            this.pcap = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    @Test
    public void testClose() {
        this.dumper.close();
        this.dumper = null;
    }

    private void checkFileSize(int n) {
        TestCase.assertEquals((int)n, (int)((int)this.file.length()));
    }

    private void checkFileSize() {
        this.checkFileSize(fileLength);
    }

    @Test
    public void testDumpJPacket() {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(1, data);
        this.dumper.dump(jMemoryPacket);
        this.checkFileSize();
    }

    @Test
    public void testDumpLongIntIntByteArray() {
        this.dumper.dump(this.seconds, this.useconds, this.wirelen, data);
        this.checkFileSize();
    }

    @Test
    public void testDumpLongIntIntByteArrayIntInt() {
        this.dumper.dump(this.seconds, this.useconds, this.wirelen, data, 10, data.length - 10);
        this.checkFileSize(fileLength - 10);
    }

    @Test
    public void testDumpLongIntIntJBuffer() {
        JBuffer jBuffer = new JBuffer(data);
        this.dumper.dump(this.seconds, this.useconds, this.wirelen, jBuffer);
        this.checkFileSize();
    }

    @Test
    public void testDumpLongIntIntJBufferIntInt() {
        JBuffer jBuffer = new JBuffer(data);
        this.dumper.dump(this.seconds, this.useconds, this.wirelen, jBuffer, 10, data.length - 10);
        this.checkFileSize(fileLength - 10);
    }

    @Test
    public void testDumpJCaptureHeaderByteBuffer() {
        PcapHeader pcapHeader = new PcapHeader(data.length, data.length);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(data.length);
        byteBuffer.put(data);
        byteBuffer.flip();
        this.dumper.dump((JCaptureHeader)pcapHeader, byteBuffer);
        this.checkFileSize();
    }

    @Test
    public void testDumpJCaptureHeaderJBuffer() {
        JBuffer jBuffer = new JBuffer(data);
        PcapHeader pcapHeader = new PcapHeader(data.length, data.length);
        this.dumper.dump((JCaptureHeader)pcapHeader, jBuffer);
        this.checkFileSize();
    }

    @Test
    public void testFlush() {
        JBuffer jBuffer = new JBuffer(data);
        PcapHeader pcapHeader = new PcapHeader(data.length, data.length);
        this.dumper.dump((JCaptureHeader)pcapHeader, jBuffer);
        this.dumper.flush();
        this.checkFileSize();
    }

    @Test
    public void testFtell() {
        JBuffer jBuffer = new JBuffer(data);
        PcapHeader pcapHeader = new PcapHeader(data.length, data.length);
        this.dumper.dump((JCaptureHeader)pcapHeader, jBuffer);
        this.dumper.flush();
        this.checkFileSize();
        TestCase.assertEquals((int)fileLength, (int)((int)this.dumper.ftell()));
    }
}

