/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Exchanger;
import junit.framework.TestCase;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapIf;
import org.jnetpcap.winpcap.WinPcap;

public class TestOpenCloseMultiThreaded
extends TestCase {
    private boolean looping = false;
    private final PcapHandler<Pcap> callback = new PcapHandler<Pcap>(){

        @Override
        public void nextPacket(Pcap pcap, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            if (!TestOpenCloseMultiThreaded.this.looping) {
                try {
                    TestOpenCloseMultiThreaded.this.exchanger.exchange(pcap);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Exchange of pcap between threads failed in child thread");
                    System.exit(1);
                }
                TestOpenCloseMultiThreaded.this.looping = true;
            }
        }
    };
    private final Exchanger<Pcap> exchanger = new Exchanger();

    private Pcap openAndLoop() {
        this.looping = false;
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        Pcap.findAllDevs(arrayList, stringBuilder);
        WinPcap winPcap = WinPcap.openLive(((PcapIf)arrayList.get(0)).getName(), 66560, 1, 0, stringBuilder);
        winPcap.setMinToCopy(0);
        winPcap.loop(0, this.callback, winPcap);
        return winPcap;
    }

    public void test1() throws InterruptedException {
        for (int i = 0; i < 30; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TestOpenCloseMultiThreaded.this.openAndLoop();
                }
            });
            thread.start();
            Pcap pcap = this.exchanger.exchange(null);
            pcap.breakloop();
            thread.join();
            pcap.close();
        }
    }
}

