/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.exceptions.RbelRenderingException;
import de.gematik.rbellogger.renderer.RbelFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Optional;

public class RbelHttpMessageRenderer
implements RbelFacetRenderer {
    public static ContainerTag buildAddressInfo(RbelElement element) {
        String icon;
        RbelHostname right;
        RbelHostname left;
        if (!element.hasFacet(RbelTcpIpMessageFacet.class)) {
            return TagCreator.span();
        }
        RbelTcpIpMessageFacet messageFacet = element.getFacet(RbelTcpIpMessageFacet.class).get();
        if (!messageFacet.getSender().seekValue().isPresent() && !messageFacet.getReceiver().seekValue().isPresent()) {
            return TagCreator.span();
        }
        if (element.hasFacet(RbelHttpRequestFacet.class)) {
            left = messageFacet.getSender().seekValue(RbelHostname.class).orElse(null);
            right = messageFacet.getReceiver().seekValue(RbelHostname.class).orElse(null);
            icon = "fa-arrow-right";
        } else {
            left = messageFacet.getReceiver().seekValue(RbelHostname.class).orElse(null);
            right = messageFacet.getSender().seekValue(RbelHostname.class).orElse(null);
            icon = "fa-arrow-left";
        }
        return (ContainerTag)TagCreator.span().withText(left == null ? "" : left.toString()).with((DomContent)RbelHtmlRenderingToolkit.icon(icon)).with((DomContent)TagCreator.text(right == null ? "" : right.toString())).withClass("is-size-6 ml-4");
    }

    @Override
    public boolean checkForRendering(RbelElement element) {
        return element.hasFacet(RbelHttpMessageFacet.class);
    }

    @Override
    public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        RbelHttpMessageFacet messageFacet = element.getFacet(RbelHttpMessageFacet.class).orElseThrow(() -> new RbelRenderingException("Unqualified call!"));
        Optional<RbelHttpRequestFacet> requestFacet = element.getFacet(RbelHttpRequestFacet.class);
        Optional<RbelHttpResponseFacet> responseFacet = element.getFacet(RbelHttpResponseFacet.class);
        return RbelHtmlRenderer.collapsibleCard((ContainerTag)TagCreator.div().with(new DomContent[]{TagCreator.a().withName(element.getUuid()), TagCreator.i().withClasses("fas fa-toggle-on toggle-icon is-pulled-right mr-3 is-size-3", requestFacet.map(f -> "has-text-link").orElse("has-text-success")), RbelHtmlRenderer.showContentButtonAndDialog(element), TagCreator.h1(new DomContent[]{renderingToolkit.constructMessageId(element), TagCreator.i().withClass(requestFacet.map(f -> "fas fa-share").orElse("fas fa-reply")), requestFacet.map(f -> TagCreator.text(" " + f.getMethod().getRawStringContent() + " ")).orElse(TagCreator.text("")), requestFacet.map(f -> TagCreator.text("Request")).orElse(TagCreator.text("Response"))}).with((DomContent)RbelHttpMessageRenderer.buildAddressInfo(element)).withClass(requestFacet.map(f -> "title has-text-link").orElse("title has-text-success")), RbelHtmlRenderingToolkit.addNote(element, new String[0]), ((ContainerTag)TagCreator.div().withClass("container is-widescreen")).with((DomContent)requestFacet.map(f -> ((ContainerTag)TagCreator.div(renderingToolkit.convert(((RbelHttpRequestFacet)requestFacet.get()).getPath(), Optional.empty())).withClass("is-family-monospace title is-size-4")).with(RbelHtmlRenderingToolkit.addNote(((RbelHttpRequestFacet)requestFacet.get()).getPath(), new String[0]))).orElseGet(() -> RbelHtmlRenderingToolkit.t1ms(((RbelHttpResponseFacet)responseFacet.get()).getResponseCode().getRawStringContent())))}).withClass("full-width"), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-parent is-vertical pr-3")).with(RbelHtmlRenderingToolkit.childBoxNotifTitle("is-primary").with(requestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Headers")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Headers")), RbelHtmlRenderingToolkit.addNote(messageFacet.getHeader(), new String[0]), renderingToolkit.convert(messageFacet.getHeader(), Optional.empty())), RbelHtmlRenderingToolkit.childBoxNotifTitle("is-info").with(requestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Body")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Body")), RbelHtmlRenderingToolkit.addNote(messageFacet.getBody(), new String[0]), renderingToolkit.convert(messageFacet.getBody(), Optional.empty())))));
    }
}

