/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.RbelHttpRequestConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.util.RbelArrayUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RbelHttpResponseConverter
implements RbelConverterPlugin {
    @Override
    public void consumeElement(RbelElement rbel, RbelConverter converter) {
        String content = rbel.getRawStringContent();
        if (!content.startsWith("HTTP")) {
            return;
        }
        String eol = RbelHttpRequestConverter.findEolInHttpMessage(content);
        int separator = content.indexOf(eol + eol);
        if (separator == -1) {
            return;
        }
        RbelElement headerElement = this.extractHeaderFromMessage(rbel, converter, eol);
        byte[] bodyData = this.extractBodyData(rbel, separator += 2 * eol.length(), headerElement.getFacet(RbelHttpHeaderFacet.class).get(), eol);
        RbelElement bodyElement = new RbelElement(bodyData, rbel);
        RbelHttpResponseFacet rbelHttpResponse = RbelHttpResponseFacet.builder().responseCode(RbelElement.builder().parentNode(rbel).rawContent(content.split("\\s")[1].getBytes()).build()).build();
        rbel.addFacet(rbelHttpResponse);
        rbel.addFacet(RbelHttpMessageFacet.builder().header(headerElement).body(bodyElement).build());
        converter.convertElement(bodyElement);
    }

    public RbelElement extractHeaderFromMessage(RbelElement rbel, RbelConverter converter, String eol) {
        String content = rbel.getRawStringContent();
        int endOfBodyPosition = content.indexOf(eol + eol);
        int endOfFirstLine = content.indexOf(eol) + eol.length();
        endOfBodyPosition = endOfBodyPosition < 0 ? content.length() : (endOfBodyPosition += 2 * eol.length());
        List headerList = Arrays.stream(content.substring(endOfFirstLine, endOfBodyPosition).split(eol)).filter(line -> !line.isEmpty() && !line.startsWith("HTTP")).collect(Collectors.toList());
        RbelElement headerElement = new RbelElement(headerList.stream().collect(Collectors.joining(eol)).getBytes(), rbel);
        Map<String, List<RbelElement>> headerMap = headerList.stream().map(line -> this.parseStringToKeyValuePair((String)line, converter, headerElement)).collect(Collectors.groupingBy(e -> (String)e.getKey(), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        headerElement.addFacet(new RbelHttpHeaderFacet(headerMap));
        return headerElement;
    }

    private byte[] extractBodyData(RbelElement rbel, int separator, RbelHttpHeaderFacet headerMap, String eol) {
        byte[] inputData = rbel.getRawContent();
        if (headerMap.hasValueMatching("Transfer-Encoding", "chunked")) {
            separator = rbel.getRawStringContent().indexOf(eol, separator) + eol.length();
            return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), RbelArrayUtils.indexOf(inputData, (eol + "0" + eol).getBytes(), separator));
        }
        return Arrays.copyOfRange(inputData, Math.min(inputData.length, separator), inputData.length);
    }

    protected AbstractMap.SimpleImmutableEntry<String, RbelElement> parseStringToKeyValuePair(String line, RbelConverter context, RbelElement headerElement) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Header malformed: '" + line + "'");
        }
        String key = line.substring(0, colon).trim();
        RbelElement el = new RbelElement(line.substring(colon + 1).trim().getBytes(), headerElement);
        return new AbstractMap.SimpleImmutableEntry<String, RbelElement>(key, context.convertElement(el));
    }
}

