/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelAsn1Facet;
import de.gematik.rbellogger.data.facet.RbelAsn1TaggedValueFacet;
import de.gematik.rbellogger.data.facet.RbelAsn1UnparsedBytesFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelNestedFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.exceptions.RbelAsn1Exception;
import de.gematik.rbellogger.util.RbelException;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelAsn1Converter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelAsn1Converter.class);

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter context) {
        if (!this.tryToParseAsn1Structure(rbelElement.getRawContent(), context, rbelElement) && !this.safeConvertBase64Using(rbelElement, Base64.getDecoder(), context)) {
            this.safeConvertBase64Using(rbelElement, Base64.getUrlDecoder(), context);
        }
    }

    private boolean safeConvertBase64Using(RbelElement rbelElement, Base64.Decoder decoder, RbelConverter context) {
        byte[] data;
        try {
            data = decoder.decode(rbelElement.getRawContent());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (data != null) {
            return this.tryToParseAsn1Structure(data, context, rbelElement);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryToParseAsn1Structure(byte[] data, RbelConverter converter, RbelElement parentNode) {
        try (ASN1InputStream input = new ASN1InputStream(data);){
            ASN1Primitive primitive;
            while ((primitive = input.readObject()) != null) {
                ASN1Sequence asn1;
                if (parentNode.hasFacet(RbelAsn1Facet.class)) {
                    if (Arrays.equals(primitive.getEncoded(), parentNode.getRawContent())) {
                        boolean bl = true;
                        return bl;
                    }
                    log.debug("Stream with multiple ASN.1 Instances encountered! Skipping");
                    boolean bl = false;
                    return bl;
                }
                try {
                    asn1 = ASN1Sequence.getInstance(primitive);
                }
                catch (IllegalArgumentException e) {
                    boolean bl = false;
                    input.close();
                    return bl;
                }
                this.convertToAsn1Facets(asn1, converter, parentNode);
                if (input.available() != 0) {
                    log.warn("Found a ASN.1-Stream with more then a single element. The rest of the element will be skipped");
                    parentNode.addFacet(new RbelAsn1UnparsedBytesFacet(new RbelElement(input.readAllBytes(), parentNode)));
                }
                parentNode.addFacet(new RbelRootFacet<RbelAsn1Facet>(parentNode.getFacetOrFail(RbelAsn1Facet.class)));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.trace("Error while parsing element", e);
            return false;
        }
    }

    private void convertToAsn1Facets(ASN1Encodable asn1, RbelConverter converter, RbelElement parentNode) throws IOException {
        parentNode.addFacet(RbelAsn1Facet.builder().asn1Content(asn1).build());
        if (asn1 instanceof ASN1Sequence || asn1 instanceof ASN1Set) {
            ArrayList<RbelElement> rbelSequence = new ArrayList<RbelElement>();
            for (ASN1Encodable encodable : (Iterable)((Object)asn1)) {
                RbelElement newChild = new RbelElement(encodable.toASN1Primitive().getEncoded(), parentNode);
                this.convertToAsn1Facets(encodable, converter, newChild);
                rbelSequence.add(newChild);
            }
            parentNode.addFacet(RbelListFacet.builder().childNodes(rbelSequence).build());
        } else if (asn1 instanceof ASN1TaggedObject) {
            int tagNo = ((ASN1TaggedObject)asn1).getTagNo();
            ASN1Primitive nestedObject = ((ASN1TaggedObject)asn1).getObject();
            RbelElement nestedElement = new RbelElement(nestedObject.getEncoded(), parentNode);
            this.convertToAsn1Facets(nestedObject, converter, nestedElement);
            parentNode.addFacet(new RbelAsn1TaggedValueFacet(RbelElement.wrap(BigInteger.valueOf(tagNo).toByteArray(), parentNode, tagNo), nestedElement));
        } else if (asn1 instanceof ASN1Integer) {
            parentNode.addFacet(RbelValueFacet.builder().value(((ASN1Integer)asn1).getValue()).build());
        } else if (asn1 instanceof ASN1ObjectIdentifier) {
            parentNode.addFacet(RbelValueFacet.builder().value(((ASN1ObjectIdentifier)asn1).getId()).build());
        } else if (asn1 instanceof ASN1OctetString) {
            byte[] octets = ((ASN1OctetString)asn1).getOctets();
            parentNode.addFacet(RbelValueFacet.builder().value(octets).build());
            this.tryToParseEmbededContentAndAddFacetIfPresent(converter, parentNode, octets);
        } else if (asn1 instanceof ASN1BitString) {
            byte[] octets = ((ASN1BitString)asn1).getOctets();
            parentNode.addFacet(RbelValueFacet.builder().value(octets).build());
            this.tryToParseEmbededContentAndAddFacetIfPresent(converter, parentNode, octets);
        } else if (asn1 instanceof ASN1String) {
            parentNode.addFacet(RbelValueFacet.builder().value(((ASN1String)((Object)asn1)).getString()).build());
            this.tryToParseEmbededContentAndAddFacetIfPresent(converter, parentNode, ((ASN1String)((Object)asn1)).getString().getBytes());
        } else if (asn1 instanceof ASN1Boolean) {
            parentNode.addFacet(RbelValueFacet.builder().value(((ASN1Boolean)asn1).isTrue()).build());
        } else if (asn1 instanceof ASN1Null) {
            parentNode.addFacet(RbelValueFacet.builder().value(null).build());
        } else if (asn1 instanceof ASN1UTCTime) {
            try {
                parentNode.addFacet(RbelValueFacet.builder().value(ZonedDateTime.ofInstant(((ASN1UTCTime)asn1).getAdjustedDate().toInstant(), ZoneId.of("UTC"))).build());
            }
            catch (ParseException e) {
                throw new RbelException("Error during time-conversion of " + asn1, e);
            }
        } else if (asn1 instanceof ASN1GeneralizedTime) {
            try {
                parentNode.addFacet(RbelValueFacet.builder().value(ZonedDateTime.ofInstant(((ASN1GeneralizedTime)asn1).getDate().toInstant(), ZoneId.of("UTC"))).build());
            }
            catch (ParseException e) {
                throw new RbelException("Error during time-conversion of " + asn1, e);
            }
        } else {
            throw new RbelAsn1Exception("Unable to convert " + asn1.getClass().getSimpleName() + "!");
        }
    }

    private void tryToParseEmbededContentAndAddFacetIfPresent(RbelConverter converter, RbelElement parentNode, byte[] octets) {
        RbelElement nestedElement = new RbelElement(octets, parentNode);
        converter.convertElement(nestedElement);
        parentNode.addFacet(new RbelNestedFacet(nestedElement));
    }
}

