/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.tests;

import de.gematik.idp.crypto.CryptoLoader;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.crypto.model.PkiIdentity;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public class PkiKeyResolver
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return parameterContext.getParameter().getType() == PkiIdentity.class;
    }

    public PkiIdentity resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.retrieveIdentityFromFileSystem(this.getFilterValueForParameter(parameterContext));
    }

    private String getFilterValueForParameter(ParameterContext parameterContext) {
        if (parameterContext.getParameter().isAnnotationPresent(Filename.class)) {
            return parameterContext.getParameter().getAnnotation(Filename.class).value();
        }
        return parameterContext.getParameter().getName();
    }

    private PkiIdentity retrieveIdentityFromFileSystem(String fileFilter) {
        PkiIdentity pkiIdentity;
        block8: {
            Stream<Path> pathStream = Files.find(Paths.get("src", "test", "resources"), 128, (p, a) -> p.toString().endsWith(".p12") && p.getFileName().toString().toLowerCase().contains(fileFilter.toLowerCase()), new FileVisitOption[0]);
            try {
                pkiIdentity = pathStream.findFirst().map(Path::toFile).map(file -> {
                    try {
                        return FileUtils.readFileToByteArray((File)file);
                    }
                    catch (IOException e) {
                        throw new IdpCryptoException((Exception)e);
                    }
                }).map(bytes -> CryptoLoader.getIdentityFromP12((byte[])bytes, (String)"00")).orElseThrow(() -> new IdpCryptoException("No matching identity found in src/test/resources and filter '" + fileFilter + "'"));
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IdpCryptoException("Error while querying file system", (Exception)e);
                }
            }
            pathStream.close();
        }
        return pkiIdentity;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Filename {
        public String value();
    }
}

