/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import lombok.Generated;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public final class KeyUtility {
    public static PublicKey readX509PublicKey(File pemFile) {
        BCECPublicKey bCECPublicKey;
        FileReader keyReader = new FileReader(pemFile);
        try {
            PEMParser pemParser = new PEMParser((Reader)keyReader);
            SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)pemParser.readObject();
            bCECPublicKey = KeyUtility.convertToBCECPublicKey(subjectPublicKeyInfo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                throw new IdpCryptoException(e);
            }
        }
        keyReader.close();
        return bCECPublicKey;
    }

    private static BCECPublicKey convertToBCECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PublicKey publicKey = converter.getPublicKey(subjectPublicKeyInfo);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPublicKey.getW(), ecPublicKey.getParams());
            return (BCECPublicKey)keyFactory.generatePublic(keySpec);
        }
        throw new IdpCryptoException("Public key is not an instance of ECPublicKey");
    }

    public static PrivateKey readX509PrivateKeyPlain(File pemFile) {
        PrivateKey privateKey;
        FileReader keyReader = new FileReader(pemFile);
        try {
            PEMParser pemParser = new PEMParser((Reader)keyReader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)pemParser.readObject());
            privateKey = converter.getPrivateKey(privateKeyInfo);
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IdpCryptoException(e);
            }
        }
        keyReader.close();
        return privateKey;
    }

    @Generated
    private KeyUtility() {
    }
}

