/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RsaSignerUtility {
    private RsaSignerUtility() {
    }

    public static byte[] createRsaSignature(byte[] toBeSignedData, PrivateKey privateKey) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSAAndMGF1", (Provider)new BouncyCastleProvider());
            signer.initSign(privateKey);
            signer.update(toBeSignedData);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IdpCryptoException(e);
        }
    }
}

