/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.CertificateAnalysis;
import de.gematik.idp.crypto.CryptoLoader;
import de.gematik.idp.crypto.TiCertificateType;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.crypto.model.CertificateExtractedFieldEnum;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class X509ClaimExtraction {
    private static final int KVNR_LENGTH = 10;
    private static final String VAL_IN_CERT_TOO_LONG = "Value in certificate too long!";

    public static Map<String, Object> extractClaimsFromCertificate(byte[] certificateData) {
        return X509ClaimExtraction.extractClaimsFromCertificate(CryptoLoader.getCertificateFromPem(certificateData));
    }

    public static Map<String, Object> extractClaimsFromCertificate(X509Certificate certificate) {
        HashMap<String, Object> claimMap = new HashMap<String, Object>();
        TiCertificateType certificateType = CertificateAnalysis.determineCertificateType(certificate);
        claimMap.put(CertificateExtractedFieldEnum.GIVEN_NAME.getFieldname(), X509ClaimExtraction.getNameValueFromDn(certificate, certificateType, RFC4519Style.givenName));
        claimMap.put(CertificateExtractedFieldEnum.FAMILY_NAME.getFieldname(), X509ClaimExtraction.getNameValueFromDn(certificate, certificateType, RFC4519Style.sn));
        if (certificateType == TiCertificateType.HBA) {
            claimMap.put(CertificateExtractedFieldEnum.ORGANIZATION_NAME.getFieldname(), null);
        } else if (certificateType == TiCertificateType.SMCB) {
            Optional<String> valueFromDn = X509ClaimExtraction.getValueFromDn(certificate.getSubjectX500Principal(), RFC4519Style.cn);
            if (valueFromDn.isPresent() && valueFromDn.get().length() > 64) {
                throw new IdpCryptoException(VAL_IN_CERT_TOO_LONG);
            }
            claimMap.put(CertificateExtractedFieldEnum.ORGANIZATION_NAME.getFieldname(), valueFromDn.orElse(null));
        } else if (certificateType == TiCertificateType.EGK) {
            Optional<String> valueFromDn = X509ClaimExtraction.getValueFromDn(certificate.getSubjectX500Principal(), RFC4519Style.o);
            if (valueFromDn.isPresent() && valueFromDn.get().length() > 64) {
                throw new IdpCryptoException(VAL_IN_CERT_TOO_LONG);
            }
            claimMap.put(CertificateExtractedFieldEnum.ORGANIZATION_NAME.getFieldname(), valueFromDn.orElse(null));
        }
        claimMap.put(CertificateExtractedFieldEnum.PROFESSION_OID.getFieldname(), X509ClaimExtraction.getProfessionOid(certificate).map(ASN1ObjectIdentifier::toString).orElse(null));
        if (certificateType == TiCertificateType.HBA) {
            claimMap.put(CertificateExtractedFieldEnum.ID_NUMMER.getFieldname(), X509ClaimExtraction.getRegistrationNumber(certificate).orElse(null));
        } else if (certificateType == TiCertificateType.SMCB) {
            claimMap.put(CertificateExtractedFieldEnum.ID_NUMMER.getFieldname(), X509ClaimExtraction.getRegistrationNumber(certificate).orElse(null));
        } else if (certificateType == TiCertificateType.EGK) {
            claimMap.put(CertificateExtractedFieldEnum.ID_NUMMER.getFieldname(), X509ClaimExtraction.getAllValuesFromDn(certificate.getSubjectX500Principal(), RFC4519Style.ou).stream().filter(ou -> ou.matches("[a-zA-Z]\\d{9}")).findFirst().orElseThrow(() -> new IdpCryptoException("Could not find OU in EGK Subject-DN: '" + certificate.getSubjectX500Principal().toString())));
        }
        return claimMap;
    }

    private static String getNameValueFromDn(X509Certificate certificate, TiCertificateType certificateType, ASN1ObjectIdentifier identifier) {
        Optional<String> valueFromDn = X509ClaimExtraction.getValueFromDn(certificate.getSubjectX500Principal(), identifier);
        if (valueFromDn.isEmpty() && (certificateType == TiCertificateType.EGK || certificateType == TiCertificateType.HBA)) {
            throw new IdpCryptoException("No value found in certificate!");
        }
        if (valueFromDn.isPresent() && valueFromDn.get().length() > 64) {
            throw new IdpCryptoException(VAL_IN_CERT_TOO_LONG);
        }
        return valueFromDn.orElse(null);
    }

    private static Optional<String> getValueFromDn(X500Principal principal, ASN1ObjectIdentifier field) {
        return X509ClaimExtraction.getAllValuesFromDn(principal, field).stream().findFirst();
    }

    private static List<String> getAllValuesFromDn(X500Principal principal, ASN1ObjectIdentifier field) {
        return Stream.of(X500Name.getInstance((Object)principal.getEncoded()).getRDNs(field)).flatMap(rdn -> Stream.of(rdn.getTypesAndValues())).filter(attributeTypeAndValue -> attributeTypeAndValue.getType().equals((ASN1Primitive)field)).map(AttributeTypeAndValue::getValue).map(Objects::toString).toList();
    }

    private static Optional<ASN1ObjectIdentifier> getProfessionOid(X509Certificate certificate) {
        Optional<DLSequence> admissionEntry = X509ClaimExtraction.getAdmissionEntry(certificate);
        if (admissionEntry.isEmpty()) {
            throw new IdpCryptoException("No profession OID found!");
        }
        for (ASN1Encodable encodable : admissionEntry.get()) {
            ASN1Encodable obj;
            if (!(encodable instanceof DLSequence) || !((obj = ((DLSequence)encodable).getObjectAt(0)) instanceof ASN1ObjectIdentifier)) continue;
            return Optional.of((ASN1ObjectIdentifier)obj);
        }
        throw new IdpCryptoException("No profession OID found!");
    }

    private static Optional<String> getRegistrationNumber(X509Certificate certificate) {
        Optional<DLSequence> admissionEntry = X509ClaimExtraction.getAdmissionEntry(certificate);
        if (admissionEntry.isEmpty()) {
            return Optional.empty();
        }
        for (ASN1Encodable encodable : admissionEntry.get()) {
            if (!(encodable instanceof DERPrintableString)) continue;
            return Optional.ofNullable(((DERPrintableString)encodable).getString());
        }
        return Optional.empty();
    }

    private static Optional<DLSequence> getAdmissionEntry(X509Certificate certificate) {
        try {
            byte[] data = certificate.getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_admission.getId());
            if (data == null) {
                return Optional.empty();
            }
            ASN1Primitive parsedValue = JcaX509ExtensionUtils.parseExtensionValue((byte[])data);
            DLSequence a = (DLSequence)parsedValue;
            DLSequence b = null;
            for (ASN1Encodable next : a) {
                if (!(next instanceof DLSequence)) continue;
                b = (DLSequence)next;
            }
            if (b == null) {
                return Optional.empty();
            }
            DLSequence c = (DLSequence)b.getObjectAt(0);
            DLSequence d = (DLSequence)c.getObjectAt(0);
            return Optional.ofNullable((DLSequence)d.getObjectAt(0));
        }
        catch (IOException e) {
            throw new IdpCryptoException(e);
        }
    }

    @Generated
    private X509ClaimExtraction() {
    }
}

