/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;

public final class Nonce {
    private static final int NONCE_BYTE_AMOUNT_MIN = 1;
    private static final int NONCE_BYTE_AMOUNT_MAX = 512;
    private static final int NONCE_STRLEN_MIN = 2;
    private static final int NONCE_STRLEN_MAX = 512;

    public static String getNonceAsBase64UrlEncodedString(int randomByteAmount) {
        if (randomByteAmount < 1 || randomByteAmount > 512) {
            throw new IdpCryptoException("Amount of random bytes is expected to be between 1 and 512");
        }
        byte[] randomArray = Nonce.randomBytes(randomByteAmount);
        return new String(Base64.getUrlEncoder().withoutPadding().encode(randomArray));
    }

    public static String getNonceAsHex(int strlen) {
        if (strlen < 2 || strlen > 512) {
            throw new IdpCryptoException("Requested string length is expected to be between 2 and 512");
        }
        if (strlen % 2 != 0) {
            throw new IdpCryptoException("Requested string length is expected to be even.");
        }
        byte[] randomArray = Nonce.randomBytes(strlen / 2);
        return Hex.toHexString((byte[])randomArray);
    }

    public static byte[] randomBytes(int numberOfBytes) {
        byte[] bytes = new byte[numberOfBytes];
        try {
            SecureRandom.getInstanceStrong().nextBytes(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdpCryptoException("Error while generating random bytes", e);
        }
        return bytes;
    }

    @Generated
    private Nonce() {
    }
}

