/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;

public class EcKeyUtility {
    public static PublicKey genPublicKey(String algorithm, ECPoint ecPoint) {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(EcKeyUtility.getStdName(algorithm)));
            ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
            ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, ecParameters);
            return KeyFactory.getInstance("EC").generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            throw new IdpCryptoException("Generation of PublicKey failed.", e);
        }
    }

    public static ECPublicKey genECPublicKey(String curve, String pXbase64, String pYbase64) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        BigInteger pX = new BigInteger(Base64.getUrlDecoder().decode(pXbase64));
        BigInteger pY = new BigInteger(Base64.getUrlDecoder().decode(pYbase64));
        return EcKeyUtility.genECPublicKey(curve, pX, pY);
    }

    public static ECPublicKey genECPublicKey(String curve, BigInteger pX, BigInteger pY) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        byte[] x = pX.toByteArray();
        byte[] y = pY.toByteArray();
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        ECPoint point = new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)curve);
        ECNamedCurveSpec spec = new ECNamedCurveSpec(curve, parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
        return (ECPublicKey)keyFactory.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)spec));
    }

    private static String getStdName(String algorithm) {
        if ("P-256".equals(algorithm)) {
            return "secp256r1";
        }
        throw new IdpCryptoException("Generation of PublicKey: algorithm not supported.");
    }

    @Generated
    private EcKeyUtility() {
    }
}

