/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.TiCertificateType;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.stream.Stream;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

public class CertificateAnalysis {
    private static final String OID_HBA_AUT = "1.2.276.0.76.4.75";
    private static final String OID_SMC_B_AUT = "1.2.276.0.76.4.77";
    private static final String OID_EGK_AUT = "1.2.276.0.76.4.70";

    public static boolean doesCertificateContainPolicyExtensionOid(X509Certificate certificate, ASN1ObjectIdentifier policyOid) {
        try {
            byte[] policyBytes = certificate.getExtensionValue(Extension.certificatePolicies.toString());
            if (policyBytes == null) {
                return false;
            }
            CertificatePolicies policies = CertificatePolicies.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])policyBytes));
            return Stream.of(policies.getPolicyInformation()).map(PolicyInformation::getPolicyIdentifier).anyMatch(policyId -> policyId.equals((ASN1Primitive)policyOid));
        }
        catch (IOException e) {
            throw new IdpCryptoException("Error while checking Policy-Extension!", e);
        }
    }

    public static TiCertificateType determineCertificateType(X509Certificate certificate) {
        if (CertificateAnalysis.doesCertificateContainPolicyExtensionOid(certificate, new ASN1ObjectIdentifier(OID_HBA_AUT))) {
            return TiCertificateType.HBA;
        }
        if (CertificateAnalysis.doesCertificateContainPolicyExtensionOid(certificate, new ASN1ObjectIdentifier(OID_SMC_B_AUT))) {
            return TiCertificateType.SMCB;
        }
        if (CertificateAnalysis.doesCertificateContainPolicyExtensionOid(certificate, new ASN1ObjectIdentifier(OID_EGK_AUT))) {
            return TiCertificateType.EGK;
        }
        return TiCertificateType.UNKNOWN;
    }

    @Generated
    private CertificateAnalysis() {
    }
}

