/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.crypto;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import lombok.Generated;

public class EcSignerUtility {
    public static byte[] createEcSignature(byte[] toBeSignedData, PrivateKey privateKey) {
        try {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(privateKey);
            signer.update(toBeSignedData);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IdpCryptoException(e);
        }
    }

    public static void verifyEcSignatureAndThrowExceptionWhenFail(byte[] toBeSignedData, PublicKey publicKey, byte[] signature) {
        try {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initVerify(publicKey);
            signer.update(toBeSignedData);
            if (!signer.verify(signature)) {
                throw new IdpCryptoException("Signature validation failed");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IdpCryptoException(e);
        }
    }

    @Generated
    private EcSignerUtility() {
    }
}

