/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import de.gematik.idp.exceptions.IdpJoseException;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import kong.unirest.json.JSONObject;
import lombok.Generated;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;

public class TokenClaimExtraction {
    public static Map<String, Object> extractClaimsFromJwtBody(String token) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipDefaultAudienceValidation().setSkipAllValidators().build();
        try {
            return jwtConsumer.process(token).getJwtClaims().getClaimsMap();
        }
        catch (InvalidJwtException e) {
            throw new IdpJoseException((Exception)((Object)e));
        }
    }

    public static Map<String, Object> extractClaimsFromJwtHeader(String token) {
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        try {
            jsonWebSignature.setCompactSerialization(token);
            return JsonUtil.parseJson((String)jsonWebSignature.getHeaders().getFullHeaderAsJsonString());
        }
        catch (JoseException e) {
            throw new IdpJoseException((Exception)((Object)e));
        }
    }

    public static JsonWebKeySet extractJwksFromBody(String token) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipDefaultAudienceValidation().setSkipAllValidators().build();
        try {
            JSONObject payload = new JSONObject(jwtConsumer.process(token).getJwtClaims().getRawJson());
            return new JsonWebKeySet(payload.get("jwks").toString());
        }
        catch (InvalidJwtException | JoseException e) {
            throw new IdpJoseException((Exception)e);
        }
    }

    public static ECPublicKey getECPublicKey(JsonWebKeySet jsonWebKeySet, String keyId) {
        JsonWebKey jsonWebKey = Objects.requireNonNull(jsonWebKeySet.findJsonWebKey(keyId, null, null, null), "Key not found in jwks");
        return ((EllipticCurveJsonWebKey)jsonWebKey).getECPublicKey();
    }

    public static ZonedDateTime claimToZonedDateTime(Long claim) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(claim * 1000L), ZoneOffset.UTC);
    }

    public static long zonedDateTimeToClaim(ZonedDateTime dateTime) {
        return dateTime.toEpochSecond();
    }

    public static ZonedDateTime claimToZonedDateTime(Object claim) {
        Objects.requireNonNull(claim);
        if (claim instanceof String) {
            String claimString = (String)claim;
            return TokenClaimExtraction.claimToZonedDateTime(Long.parseLong(claimString));
        }
        if (claim instanceof Long) {
            Long claimLong = (Long)claim;
            return TokenClaimExtraction.claimToZonedDateTime(claimLong);
        }
        if (claim instanceof Integer) {
            Integer claimInt = (Integer)claim;
            return TokenClaimExtraction.claimToZonedDateTime(Integer.toUnsignedLong(claimInt));
        }
        throw new IllegalArgumentException("Couldn't convert claim: " + claim.getClass().getSimpleName());
    }

    @Generated
    private TokenClaimExtraction() {
    }
}

