/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.crypto.X509ClaimExtraction;
import de.gematik.idp.data.IdpKeyDescriptor;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.JsonWebToken;
import de.gematik.idp.token.TokenClaimExtraction;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SsoTokenBuilder {
    private final IdpJwtProcessor jwtProcessor;
    private final String issuerUrl;
    private final Key tokenEncryptionKey;

    public IdpJwe buildSsoToken(X509Certificate certificate, ZonedDateTime issuingTime, List<String> amrString) {
        HashMap<String, Object> bodyClaimsMap = new HashMap<String, Object>();
        HashMap<String, Object> headerClaimsMap = new HashMap<String, Object>();
        headerClaimsMap.put(ClaimName.ALGORITHM.getJoseName(), BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256);
        bodyClaimsMap.put(ClaimName.CONFIRMATION.getJoseName(), IdpKeyDescriptor.constructFromX509Certificate(certificate, certificate.getSerialNumber().toString()));
        headerClaimsMap.put(ClaimName.TYPE.getJoseName(), "JWT");
        bodyClaimsMap.put(ClaimName.ISSUER.getJoseName(), this.issuerUrl);
        bodyClaimsMap.put(ClaimName.ISSUED_AT.getJoseName(), issuingTime.toEpochSecond());
        bodyClaimsMap.put(ClaimName.AUTH_TIME.getJoseName(), issuingTime.toEpochSecond());
        bodyClaimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), amrString);
        bodyClaimsMap.putAll(X509ClaimExtraction.extractClaimsFromCertificate((X509Certificate)certificate));
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllHeaderClaims(headerClaimsMap).addAllBodyClaims(bodyClaimsMap).expiresAt(issuingTime.plusHours(12L))).encryptAsNjwt(this.tokenEncryptionKey);
    }

    public IdpJwe buildSsoTokenFromSektoralIdToken(JsonWebToken idToken, ZonedDateTime issueingTime) {
        HashMap<String, Object> bodyClaimsMap = new HashMap<String, Object>();
        HashMap<String, Object> headerClaimsMap = new HashMap<String, Object>();
        Map<String, Object> claimsFromIdToken = TokenClaimExtraction.extractClaimsFromJwtBody(idToken.getRawString());
        headerClaimsMap.put(ClaimName.ALGORITHM.getJoseName(), BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256);
        headerClaimsMap.put(ClaimName.TYPE.getJoseName(), "JWT");
        bodyClaimsMap.put(ClaimName.ISSUER.getJoseName(), this.issuerUrl);
        bodyClaimsMap.put(ClaimName.ISSUED_AT.getJoseName(), issueingTime.toEpochSecond());
        bodyClaimsMap.put(ClaimName.AUTH_TIME.getJoseName(), issueingTime.toEpochSecond());
        bodyClaimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), List.of("mfa"));
        bodyClaimsMap.put(ClaimName.GIVEN_NAME.getJoseName(), claimsFromIdToken.get(ClaimName.GIVEN_NAME.getJoseName()));
        bodyClaimsMap.put(ClaimName.FAMILY_NAME.getJoseName(), claimsFromIdToken.get(ClaimName.FAMILY_NAME.getJoseName()));
        bodyClaimsMap.put(ClaimName.ID_NUMBER.getJoseName(), claimsFromIdToken.get(ClaimName.ID_NUMBER.getJoseName()));
        bodyClaimsMap.put(ClaimName.PROFESSION_OID.getJoseName(), claimsFromIdToken.get(ClaimName.PROFESSION_OID.getJoseName()));
        bodyClaimsMap.put(ClaimName.ORGANIZATION_NAME.getJoseName(), claimsFromIdToken.get(ClaimName.ORGANIZATION_NAME.getJoseName()));
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllHeaderClaims(headerClaimsMap).addAllBodyClaims(bodyClaimsMap).expiresAt(issueingTime.plusHours(12L))).encryptAsNjwt(this.tokenEncryptionKey);
    }

    @Generated
    public SsoTokenBuilder(IdpJwtProcessor jwtProcessor, String issuerUrl, Key tokenEncryptionKey) {
        this.jwtProcessor = jwtProcessor;
        this.issuerUrl = issuerUrl;
        this.tokenEncryptionKey = tokenEncryptionKey;
    }

    @Generated
    public IdpJwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @Generated
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @Generated
    public Key getTokenEncryptionKey() {
        return this.tokenEncryptionKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SsoTokenBuilder)) {
            return false;
        }
        SsoTokenBuilder other = (SsoTokenBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdpJwtProcessor this$jwtProcessor = this.getJwtProcessor();
        IdpJwtProcessor other$jwtProcessor = other.getJwtProcessor();
        if (this$jwtProcessor == null ? other$jwtProcessor != null : !this$jwtProcessor.equals(other$jwtProcessor)) {
            return false;
        }
        String this$issuerUrl = this.getIssuerUrl();
        String other$issuerUrl = other.getIssuerUrl();
        if (this$issuerUrl == null ? other$issuerUrl != null : !this$issuerUrl.equals(other$issuerUrl)) {
            return false;
        }
        Key this$tokenEncryptionKey = this.getTokenEncryptionKey();
        Key other$tokenEncryptionKey = other.getTokenEncryptionKey();
        return !(this$tokenEncryptionKey == null ? other$tokenEncryptionKey != null : !this$tokenEncryptionKey.equals(other$tokenEncryptionKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SsoTokenBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdpJwtProcessor $jwtProcessor = this.getJwtProcessor();
        result = result * 59 + ($jwtProcessor == null ? 43 : $jwtProcessor.hashCode());
        String $issuerUrl = this.getIssuerUrl();
        result = result * 59 + ($issuerUrl == null ? 43 : $issuerUrl.hashCode());
        Key $tokenEncryptionKey = this.getTokenEncryptionKey();
        result = result * 59 + ($tokenEncryptionKey == null ? 43 : $tokenEncryptionKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SsoTokenBuilder(jwtProcessor=" + this.getJwtProcessor() + ", issuerUrl=" + this.getIssuerUrl() + ", tokenEncryptionKey=" + this.getTokenEncryptionKey() + ")";
    }
}

