/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.exceptions.IdpRuntimeException;
import de.gematik.idp.exceptions.RequiredClaimException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import de.gematik.idp.token.TokenBuilderUtil;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwt.NumericDate;

public class AccessTokenBuilder {
    private static final List<ClaimName> CLAIMS_TO_TAKE_FROM_AUTHENTICATION_TOKEN = List.of(ClaimName.PROFESSION_OID, ClaimName.GIVEN_NAME, ClaimName.FAMILY_NAME, ClaimName.ORGANIZATION_NAME, ClaimName.ID_NUMBER, ClaimName.CLIENT_ID, ClaimName.SCOPE, ClaimName.AUTH_TIME);
    private final IdpJwtProcessor jwtProcessor;
    private final String issuerUrl;
    private final String serverSubjectSalt;
    private final Map<String, String> scopeToAudienceUrl;
    private final ClaimName[] nonPairingClaims = new ClaimName[]{ClaimName.PROFESSION_OID, ClaimName.GIVEN_NAME, ClaimName.FAMILY_NAME, ClaimName.ORGANIZATION_NAME};

    public JsonWebToken buildAccessToken(JsonWebToken authenticationToken) {
        ZonedDateTime now = ZonedDateTime.now();
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        String clientId = authenticationToken.getBodyClaim(ClaimName.CLIENT_ID).orElseThrow(() -> new RequiredClaimException("Unable to obtain " + ClaimName.CLIENT_ID.getJoseName() + "!")).toString();
        CLAIMS_TO_TAKE_FROM_AUTHENTICATION_TOKEN.stream().map(claimName -> Pair.of((Object)claimName, authenticationToken.getBodyClaim((ClaimName)((Object)claimName)))).forEach(pair -> claimsMap.put(((ClaimName)((Object)((Object)pair.getKey()))).getJoseName(), ((Optional)pair.getValue()).isPresent() ? (Object)((Optional)pair.getValue()).get() : null));
        if (authenticationToken.getScopesBodyClaim().contains("pairing")) {
            Arrays.stream(this.nonPairingClaims).forEach(claim -> claimsMap.remove(claim.getJoseName()));
        }
        if (authenticationToken.getScopesBodyClaim().contains("e-rezept")) {
            Optional<Object> displayName = authenticationToken.getBodyClaim(ClaimName.DISPLAY_NAME);
            TokenBuilderUtil.addDisplayNameToBodyClaims(displayName, claimsMap);
        }
        claimsMap.put(ClaimName.ISSUED_AT.getJoseName(), now.toEpochSecond());
        claimsMap.put(ClaimName.ISSUER.getJoseName(), this.issuerUrl);
        claimsMap.put(ClaimName.AUTHENTICATION_CLASS_REFERENCE.getJoseName(), "gematik-ehealth-loa-high");
        claimsMap.put(ClaimName.AUDIENCE.getJoseName(), this.determineAudienceBasedOnScope(authenticationToken.getScopesBodyClaim()));
        claimsMap.put(ClaimName.SUBJECT.getJoseName(), TokenBuilderUtil.buildSubjectClaim(clientId, authenticationToken.getStringBodyClaim(ClaimName.ID_NUMBER).orElseThrow(() -> new RequiredClaimException("Missing '" + ClaimName.ID_NUMBER.getJoseName() + "' claim!")), this.serverSubjectSalt));
        claimsMap.put(ClaimName.AUTHORIZED_PARTY.getJoseName(), clientId);
        claimsMap.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        claimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), authenticationToken.getBodyClaim(ClaimName.AUTHENTICATION_METHODS_REFERENCE).orElse(this.getAmrString()));
        claimsMap.put(ClaimName.EXPIRES_AT.getJoseName(), NumericDate.fromSeconds((long)now.plusMinutes(5L).toEpochSecond()).getValue());
        HashMap<String, Object> headerClaimsMap = new HashMap<String, Object>();
        headerClaimsMap.put(ClaimName.TYPE.getJoseName(), "at+JWT");
        return this.jwtProcessor.buildJwt(new JwtBuilder().replaceAllBodyClaims(claimsMap).replaceAllHeaderClaims(headerClaimsMap));
    }

    private String determineAudienceBasedOnScope(Set<String> scopesBodyClaim) {
        List<String> audienceUrls = scopesBodyClaim.stream().filter(scope -> !scope.equals("openid")).filter(this.scopeToAudienceUrl::containsKey).map(this.scopeToAudienceUrl::get).toList();
        if (audienceUrls.size() == 1) {
            return audienceUrls.get(0);
        }
        throw new IdpRuntimeException("Could not determine Audience for scopes '" + scopesBodyClaim + "'");
    }

    private String[] getAmrString() {
        return new String[]{"mfa", "sc", "pin"};
    }

    @Generated
    public AccessTokenBuilder(IdpJwtProcessor jwtProcessor, String issuerUrl, String serverSubjectSalt, Map<String, String> scopeToAudienceUrl) {
        this.jwtProcessor = jwtProcessor;
        this.issuerUrl = issuerUrl;
        this.serverSubjectSalt = serverSubjectSalt;
        this.scopeToAudienceUrl = scopeToAudienceUrl;
    }

    @Generated
    public IdpJwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @Generated
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @Generated
    public String getServerSubjectSalt() {
        return this.serverSubjectSalt;
    }

    @Generated
    public Map<String, String> getScopeToAudienceUrl() {
        return this.scopeToAudienceUrl;
    }

    @Generated
    public ClaimName[] getNonPairingClaims() {
        return this.nonPairingClaims;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessTokenBuilder)) {
            return false;
        }
        AccessTokenBuilder other = (AccessTokenBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdpJwtProcessor this$jwtProcessor = this.getJwtProcessor();
        IdpJwtProcessor other$jwtProcessor = other.getJwtProcessor();
        if (this$jwtProcessor == null ? other$jwtProcessor != null : !this$jwtProcessor.equals(other$jwtProcessor)) {
            return false;
        }
        String this$issuerUrl = this.getIssuerUrl();
        String other$issuerUrl = other.getIssuerUrl();
        if (this$issuerUrl == null ? other$issuerUrl != null : !this$issuerUrl.equals(other$issuerUrl)) {
            return false;
        }
        String this$serverSubjectSalt = this.getServerSubjectSalt();
        String other$serverSubjectSalt = other.getServerSubjectSalt();
        if (this$serverSubjectSalt == null ? other$serverSubjectSalt != null : !this$serverSubjectSalt.equals(other$serverSubjectSalt)) {
            return false;
        }
        Map<String, String> this$scopeToAudienceUrl = this.getScopeToAudienceUrl();
        Map<String, String> other$scopeToAudienceUrl = other.getScopeToAudienceUrl();
        if (this$scopeToAudienceUrl == null ? other$scopeToAudienceUrl != null : !((Object)this$scopeToAudienceUrl).equals(other$scopeToAudienceUrl)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getNonPairingClaims(), (Object[])other.getNonPairingClaims());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccessTokenBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdpJwtProcessor $jwtProcessor = this.getJwtProcessor();
        result = result * 59 + ($jwtProcessor == null ? 43 : $jwtProcessor.hashCode());
        String $issuerUrl = this.getIssuerUrl();
        result = result * 59 + ($issuerUrl == null ? 43 : $issuerUrl.hashCode());
        String $serverSubjectSalt = this.getServerSubjectSalt();
        result = result * 59 + ($serverSubjectSalt == null ? 43 : $serverSubjectSalt.hashCode());
        Map<String, String> $scopeToAudienceUrl = this.getScopeToAudienceUrl();
        result = result * 59 + ($scopeToAudienceUrl == null ? 43 : ((Object)$scopeToAudienceUrl).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getNonPairingClaims());
        return result;
    }

    @Generated
    public String toString() {
        return "AccessTokenBuilder(jwtProcessor=" + this.getJwtProcessor() + ", issuerUrl=" + this.getIssuerUrl() + ", serverSubjectSalt=" + this.getServerSubjectSalt() + ", scopeToAudienceUrl=" + this.getScopeToAudienceUrl() + ", nonPairingClaims=" + Arrays.deepToString((Object[])this.getNonPairingClaims()) + ")";
    }
}

