/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.data.FederationPubKey;
import de.gematik.idp.data.IdpJwksDocument;
import de.gematik.idp.data.IdpKeyDescriptor;
import de.gematik.idp.exceptions.IdpRuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public final class JwtHelper {
    public static String signJson(IdpJwtProcessor jwtProcessor, ObjectMapper objectMapper, Object object, String typ) {
        try {
            return jwtProcessor.buildJws(objectMapper.writeValueAsString(object), Map.ofEntries(Map.entry("typ", typ)), false).getRawString();
        }
        catch (JsonProcessingException e) {
            throw new IdpRuntimeException("EntityStatement to json failed", (Exception)((Object)e));
        }
    }

    public static String invalidateJsonSignature(String jwsRawString) {
        String invalidSignatureValue = "Is8Ag-3Z0DwWS7RXCSRDPy1_m3bZatBB12PFOmTa8cBw0WrzixE23VL6xFeBFAFowlez-QQKU_WRhyPkX18-wQ";
        CharSequence[] splitJws = jwsRawString.split("\\.");
        splitJws[2] = "Is8Ag-3Z0DwWS7RXCSRDPy1_m3bZatBB12PFOmTa8cBw0WrzixE23VL6xFeBFAFowlez-QQKU_WRhyPkX18-wQ";
        return String.join((CharSequence)".", splitJws);
    }

    public static IdpJwksDocument getJwks(FederationPubKey ... federationPubKeys) {
        if (federationPubKeys == null) {
            throw new NullPointerException("federationPubKeys is marked non-null but is null");
        }
        ArrayList<IdpKeyDescriptor> keyDescriptors = new ArrayList<IdpKeyDescriptor>(Stream.of(federationPubKeys).filter(federationPubKey -> federationPubKey.getCertificate().isPresent()).map(federationPubKey -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(federationPubKey.getCertificate().orElseThrow(), federationPubKey.getKeyId(), true);
            keyDesc.setPublicKeyUse(federationPubKey.getUse().orElse(null));
            return keyDesc;
        }).toList());
        List<IdpKeyDescriptor> keyDescriptorsWithoutX5c = Stream.of(federationPubKeys).filter(federationPubKey -> federationPubKey.getPublicKey().isPresent()).map(federationPubKey -> {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.createFromPublicKey(federationPubKey.getPublicKey().orElseThrow(), federationPubKey.getKeyId());
            keyDesc.setPublicKeyUse(federationPubKey.getUse().orElse(null));
            return keyDesc;
        }).toList();
        keyDescriptors.addAll(keyDescriptorsWithoutX5c);
        return IdpJwksDocument.builder().keys(keyDescriptors).build();
    }

    @Generated
    private JwtHelper() {
    }
}

