/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.data.IdpKeyDescriptor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;

public class IdpRsaKeyDescriptor
extends IdpKeyDescriptor {
    @JsonProperty(value="n")
    private String rsaModulusValue;
    @JsonProperty(value="e")
    private String rsaExponentValue;

    public IdpRsaKeyDescriptor(String[] x5c, String publicKeyUse, String keyId, String keyType, String rsaModulusValue, String rsaExponentValue) {
        super(x5c, publicKeyUse, keyId, keyType);
        this.rsaModulusValue = rsaModulusValue;
        this.rsaExponentValue = rsaExponentValue;
    }

    public static IdpKeyDescriptor constructFromX509Certificate(X509Certificate certificate, String keyId) {
        try {
            IdpRsaKeyDescriptorBuilder descriptorBuilder = IdpRsaKeyDescriptor.builder().keyId(keyId).keyType(IdpRsaKeyDescriptor.getKeyType(certificate));
            descriptorBuilder.x5c(IdpRsaKeyDescriptor.getCertArray(certificate));
            BCRSAPublicKey bcrsaPublicKey = (BCRSAPublicKey)certificate.getPublicKey();
            descriptorBuilder.rsaModulusValue(Base64.getUrlEncoder().withoutPadding().encodeToString(bcrsaPublicKey.getModulus().toByteArray())).rsaExponentValue(Base64.getUrlEncoder().withoutPadding().encodeToString(bcrsaPublicKey.getPublicExponent().toByteArray()));
            return descriptorBuilder.build();
        }
        catch (ClassCastException e) {
            throw new IdpCryptoException("Unknown Key-Format encountered!", (Exception)e);
        }
    }

    @Generated
    public static IdpRsaKeyDescriptorBuilder builder() {
        return new IdpRsaKeyDescriptorBuilder();
    }

    @Generated
    public String getRsaModulusValue() {
        return this.rsaModulusValue;
    }

    @Generated
    public String getRsaExponentValue() {
        return this.rsaExponentValue;
    }

    @JsonProperty(value="n")
    @Generated
    public void setRsaModulusValue(String rsaModulusValue) {
        this.rsaModulusValue = rsaModulusValue;
    }

    @JsonProperty(value="e")
    @Generated
    public void setRsaExponentValue(String rsaExponentValue) {
        this.rsaExponentValue = rsaExponentValue;
    }

    @Generated
    public IdpRsaKeyDescriptor(String rsaModulusValue, String rsaExponentValue) {
        this.rsaModulusValue = rsaModulusValue;
        this.rsaExponentValue = rsaExponentValue;
    }

    @Generated
    public IdpRsaKeyDescriptor() {
    }

    @Generated
    public static class IdpRsaKeyDescriptorBuilder {
        @Generated
        private String[] x5c;
        @Generated
        private String publicKeyUse;
        @Generated
        private String keyId;
        @Generated
        private String keyType;
        @Generated
        private String rsaModulusValue;
        @Generated
        private String rsaExponentValue;

        @Generated
        IdpRsaKeyDescriptorBuilder() {
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder x5c(String[] x5c) {
            this.x5c = x5c;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder publicKeyUse(String publicKeyUse) {
            this.publicKeyUse = publicKeyUse;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder rsaModulusValue(String rsaModulusValue) {
            this.rsaModulusValue = rsaModulusValue;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptorBuilder rsaExponentValue(String rsaExponentValue) {
            this.rsaExponentValue = rsaExponentValue;
            return this;
        }

        @Generated
        public IdpRsaKeyDescriptor build() {
            return new IdpRsaKeyDescriptor(this.x5c, this.publicKeyUse, this.keyId, this.keyType, this.rsaModulusValue, this.rsaExponentValue);
        }

        @Generated
        public String toString() {
            return "IdpRsaKeyDescriptor.IdpRsaKeyDescriptorBuilder(x5c=" + Arrays.deepToString(this.x5c) + ", publicKeyUse=" + this.publicKeyUse + ", keyId=" + this.keyId + ", keyType=" + this.keyType + ", rsaModulusValue=" + this.rsaModulusValue + ", rsaExponentValue=" + this.rsaExponentValue + ")";
        }
    }
}

