/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.data.IdpKeyDescriptor;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;

public class FederationPubKey {
    private Optional<X509Certificate> certificate = Optional.empty();
    private Optional<PublicKey> publicKey = Optional.empty();
    private String keyId;
    private Optional<String> use = Optional.empty();

    public IdpKeyDescriptor buildJwkWithX5c() {
        return IdpKeyDescriptor.constructFromX509Certificate(this.certificate.orElseThrow(), this.keyId, true);
    }

    public IdpKeyDescriptor buildJwkWithoutX5c() {
        if (this.publicKey.isPresent()) {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.createFromPublicKey(this.publicKey.get(), this.keyId);
            this.use.ifPresent(keyDesc::setPublicKeyUse);
            return keyDesc;
        }
        if (this.certificate.isPresent()) {
            IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(this.certificate.get(), this.keyId, false);
            this.use.ifPresent(keyDesc::setPublicKeyUse);
            return keyDesc;
        }
        throw new IdpCryptoException("FederationPubKey invalid. No PublicKey or certificate present.");
    }

    @Generated
    public void setCertificate(Optional<X509Certificate> certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setPublicKey(Optional<PublicKey> publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @Generated
    public void setUse(Optional<String> use) {
        this.use = use;
    }

    @Generated
    public FederationPubKey(Optional<X509Certificate> certificate, Optional<PublicKey> publicKey, String keyId, Optional<String> use) {
        this.certificate = certificate;
        this.publicKey = publicKey;
        this.keyId = keyId;
        this.use = use;
    }

    @Generated
    public FederationPubKey() {
    }

    @Generated
    public Optional<X509Certificate> getCertificate() {
        return this.certificate;
    }

    @Generated
    public Optional<PublicKey> getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getKeyId() {
        return this.keyId;
    }

    @Generated
    public Optional<String> getUse() {
        return this.use;
    }
}

