/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;

public class JwtBuilder {
    private final Map<String, Object> headerClaims = new HashMap<String, Object>();
    private final Map<String, Object> bodyClaims = new HashMap<String, Object>();
    private Key signerKey;
    private X509Certificate certificate;
    private boolean includeSignerCertificateInHeader = false;

    public JwtBuilder replaceAllBodyClaims(Map<String, Object> additionalClaims) {
        this.bodyClaims.clear();
        this.bodyClaims.putAll(additionalClaims);
        return this;
    }

    public JwtBuilder addAllBodyClaims(Map<String, Object> additionalClaims) {
        this.bodyClaims.putAll(additionalClaims);
        return this;
    }

    public JwtBuilder replaceAllHeaderClaims(Map<String, Object> additionalClaims) {
        this.headerClaims.clear();
        this.headerClaims.putAll(additionalClaims);
        return this;
    }

    public JwtBuilder addAllHeaderClaims(Map<String, Object> additionalClaims) {
        this.headerClaims.putAll(additionalClaims);
        return this;
    }

    public JwtBuilder addHeaderClaim(ClaimName key, Object value) {
        this.headerClaims.put(key.getJoseName(), value);
        return this;
    }

    public JwtBuilder addBodyClaim(ClaimName key, Object value) {
        this.bodyClaims.put(key.getJoseName(), value);
        return this;
    }

    public JwtBuilder expiresAt(ZonedDateTime exp) {
        NumericDate expDate = NumericDate.fromSeconds((long)exp.toEpochSecond());
        this.bodyClaims.put(ClaimName.EXPIRES_AT.getJoseName(), expDate.getValue());
        return this;
    }

    public JwtBuilder setSignerKey(Key key) {
        this.signerKey = key;
        return this;
    }

    public JwtBuilder setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public JwtBuilder setIdentity(PkiIdentity pkiIdentity) {
        this.certificate = pkiIdentity.getCertificate();
        this.signerKey = pkiIdentity.getPrivateKey();
        return this;
    }

    public JsonWebToken buildJwt() {
        Objects.requireNonNull(this.signerKey, "No private key supplied, cancelling JWT signing");
        JwtClaims claims = new JwtClaims();
        this.bodyClaims.forEach((arg_0, arg_1) -> ((JwtClaims)claims).setClaim(arg_0, arg_1));
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey(this.signerKey);
        jws.setAlgorithmHeaderValue(this.determineAlgorithm());
        this.headerClaims.keySet().forEach(key -> jws.setHeader(key, this.headerClaims.get(key)));
        if (this.includeSignerCertificateInHeader) {
            if (this.certificate == null) {
                throw new IdpJoseException("Could not include x5c-header: certificate not set");
            }
            jws.setCertificateChainHeaderValue(new X509Certificate[]{this.certificate});
        }
        try {
            return new JsonWebToken(jws.getCompactSerialization());
        }
        catch (JoseException e) {
            throw new IdpJoseException((Exception)((Object)e));
        }
    }

    private String determineAlgorithm() {
        Key key = this.signerKey;
        if (key instanceof ECPrivateKey) {
            ECNamedCurveSpec ecNamedCurveSpec;
            ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
            ECParameterSpec eCParameterSpec = ecPrivateKey.getParams();
            if (eCParameterSpec instanceof ECNamedCurveSpec && (ecNamedCurveSpec = (ECNamedCurveSpec)eCParameterSpec).getName().equals("prime256v1")) {
                return "ES256";
            }
            return BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256;
        }
        if (this.signerKey instanceof RSAPrivateKey) {
            return "PS256";
        }
        throw new IdpCryptoException("Could not identify Signer-Key: " + this.signerKey.getClass());
    }

    public Map<String, Object> getClaims() {
        return this.bodyClaims;
    }

    public JwtBuilder includeSignerCertificateInHeader(boolean shouldInclude) {
        this.includeSignerCertificateInHeader = shouldInclude;
        return this;
    }

    @Generated
    public JwtBuilder() {
    }

    @Generated
    public JwtBuilder(Key signerKey, X509Certificate certificate, boolean includeSignerCertificateInHeader) {
        this.signerKey = signerKey;
        this.certificate = certificate;
        this.includeSignerCertificateInHeader = includeSignerCertificateInHeader;
    }
}

