/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.AuthenticationResponse;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.exceptions.ChallengeExpiredException;
import de.gematik.idp.exceptions.ChallengeSignatureInvalidException;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.exceptions.NoNestedJwtFoundException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class AuthenticationChallengeVerifier {
    private PublicKey serverPublicKey;

    public void verifyResponseAndThrowExceptionIfFail(JsonWebToken authenticationResponse) {
        X509Certificate clientCertificate = this.extractClientCertificateFromChallenge(authenticationResponse).orElseThrow(() -> new IdpJoseException("Could not extract client certificate from challenge response header"));
        this.performClientSignatureValidation(clientCertificate, authenticationResponse.getRawString());
        this.performServerSignatureValidationOfNjwt(authenticationResponse);
    }

    public void verifyResponseWithCertAndThrowExceptionIfFail(X509Certificate authCert, JsonWebToken authenticationResponse) {
        this.performClientSignatureValidation(authCert, authenticationResponse.getRawString());
    }

    private void performClientSignatureValidation(X509Certificate clientCertificate, String authResponse) {
        JwtConsumer serverJwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)clientCertificate.getPublicKey()).setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"PS256", BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256})).build();
        try {
            serverJwtConsumer.process(authResponse);
        }
        catch (Exception e) {
            throw new ChallengeSignatureInvalidException(e);
        }
    }

    private void performServerSignatureValidationOfNjwt(JsonWebToken authenticationResponse) {
        JsonWebToken serverChallenge = authenticationResponse.getBodyClaim(ClaimName.NESTED_JWT).map(njwt -> new JsonWebToken(njwt.toString())).orElseThrow(NoNestedJwtFoundException::new);
        if (serverChallenge.getExpiresAt().isBefore(ZonedDateTime.now()) || serverChallenge.getExpiresAtBody().isBefore(ZonedDateTime.now())) {
            throw new ChallengeExpiredException();
        }
        try {
            serverChallenge.verify(this.serverPublicKey);
        }
        catch (Exception e) {
            throw new ChallengeSignatureInvalidException();
        }
    }

    public Optional<X509Certificate> extractClientCertificateFromChallenge(JsonWebToken authenticationResponse) {
        return authenticationResponse.getClientCertificateFromHeader();
    }

    public Map<String, Object> extractClaimsFromSignedChallenge(AuthenticationResponse authenticationResponse) {
        return authenticationResponse.getSignedChallenge().getBodyClaims();
    }

    @Generated
    public static AuthenticationChallengeVerifierBuilder builder() {
        return new AuthenticationChallengeVerifierBuilder();
    }

    @Generated
    public PublicKey getServerPublicKey() {
        return this.serverPublicKey;
    }

    @Generated
    public void setServerPublicKey(PublicKey serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationChallengeVerifier)) {
            return false;
        }
        AuthenticationChallengeVerifier other = (AuthenticationChallengeVerifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublicKey this$serverPublicKey = this.getServerPublicKey();
        PublicKey other$serverPublicKey = other.getServerPublicKey();
        return !(this$serverPublicKey == null ? other$serverPublicKey != null : !this$serverPublicKey.equals(other$serverPublicKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationChallengeVerifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKey $serverPublicKey = this.getServerPublicKey();
        result = result * 59 + ($serverPublicKey == null ? 43 : $serverPublicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationChallengeVerifier(serverPublicKey=" + this.getServerPublicKey() + ")";
    }

    @Generated
    public AuthenticationChallengeVerifier(PublicKey serverPublicKey) {
        this.serverPublicKey = serverPublicKey;
    }

    @Generated
    public static class AuthenticationChallengeVerifierBuilder {
        @Generated
        private PublicKey serverPublicKey;

        @Generated
        AuthenticationChallengeVerifierBuilder() {
        }

        @Generated
        public AuthenticationChallengeVerifierBuilder serverPublicKey(PublicKey serverPublicKey) {
            this.serverPublicKey = serverPublicKey;
            return this;
        }

        @Generated
        public AuthenticationChallengeVerifier build() {
            return new AuthenticationChallengeVerifier(this.serverPublicKey);
        }

        @Generated
        public String toString() {
            return "AuthenticationChallengeVerifier.AuthenticationChallengeVerifierBuilder(serverPublicKey=" + this.serverPublicKey + ")";
        }
    }
}

