/*
 *  Copyright 2023 gematik GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.idp.field;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum AuthenticationMethodReference {
  MULTI_FACTOR_AUTHENTICATON("mfa", false),
  SMARTCARD("sc", false),
  PIN("pin", false),
  HARDWARE_KEY("hwk", true),
  FACE_UNLOCK("face", true),
  FINGERPRINT("fpt", true),
  PASSWORD("pwd", true);

  private final String description;
  private final boolean isAlternativeAuthentication;
}
