/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.data.IdpKeyDescriptor;
import java.util.Optional;
import lombok.Generated;

public class FederationPrivKey {
    private final PkiIdentity identity;
    private Optional<Boolean> addX5c;
    private Optional<String> keyId;
    private Optional<String> use;

    public IdpKeyDescriptor buildJwk() {
        IdpKeyDescriptor keyDesc = IdpKeyDescriptor.constructFromX509Certificate(this.identity.getCertificate(), this.keyId, this.addX5c.orElse(false));
        keyDesc.setPublicKeyUse(this.use.orElse(null));
        return keyDesc;
    }

    @Generated
    public FederationPrivKey(PkiIdentity identity) {
        this.identity = identity;
    }

    @Generated
    public PkiIdentity getIdentity() {
        return this.identity;
    }

    @Generated
    public Optional<Boolean> getAddX5c() {
        return this.addX5c;
    }

    @Generated
    public Optional<String> getKeyId() {
        return this.keyId;
    }

    @Generated
    public Optional<String> getUse() {
        return this.use;
    }

    @Generated
    public void setAddX5c(Optional<Boolean> addX5c) {
        this.addX5c = addX5c;
    }

    @Generated
    public void setKeyId(Optional<String> keyId) {
        this.keyId = keyId;
    }

    @Generated
    public void setUse(Optional<String> use) {
        this.use = use;
    }
}

