/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import de.gematik.idp.field.ClaimName;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public final class TokenBuilderUtil {
    public static String buildSubjectClaim(String audClaim, String idNummerClaim, String serverSubjectSalt) {
        return Base64.encodeBase64URLSafeString((byte[])DigestUtils.sha256((String)(audClaim + idNummerClaim + serverSubjectSalt)));
    }

    private static String buildDisplayNameFromGivenNameAndFamilyName(String givenName, String familyName) {
        if (givenName == null || familyName == null) {
            return null;
        }
        return givenName + " " + familyName;
    }

    public static void addDisplayNameToBodyClaims(Optional<Object> displayName, Map<String, Object> claimsMap) {
        if (displayName.isPresent()) {
            claimsMap.put(ClaimName.DISPLAY_NAME.getJoseName(), displayName.get());
        } else {
            claimsMap.put(ClaimName.DISPLAY_NAME.getJoseName(), TokenBuilderUtil.buildDisplayNameFromGivenNameAndFamilyName((String)claimsMap.get(ClaimName.GIVEN_NAME.getJoseName()), (String)claimsMap.get(ClaimName.FAMILY_NAME.getJoseName())));
        }
    }

    @Generated
    private TokenBuilderUtil() {
    }
}

