/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.gematik.idp.crypto.CryptoLoader;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import de.gematik.idp.token.TokenClaimExtraction;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.codec.binary.StringUtils;

public abstract class IdpJoseObject {
    private final String rawString;
    private Map<String, Object> headerClaims;
    private Map<String, Object> bodyClaims;

    public abstract Map<String, Object> extractHeaderClaims();

    public Map<String, Object> getHeaderClaims() {
        if (this.headerClaims == null) {
            this.headerClaims = this.extractHeaderClaims();
        }
        return this.headerClaims;
    }

    public abstract Map<String, Object> extractBodyClaims();

    public Map<String, Object> getBodyClaims() {
        if (this.bodyClaims == null) {
            this.bodyClaims = this.extractBodyClaims();
        }
        return this.bodyClaims;
    }

    public ZonedDateTime getExpiresAt() {
        return this.getDateTimeClaim(ClaimName.EXPIRES_AT, this::getBodyClaims).orElseThrow();
    }

    public ZonedDateTime getExpiresAtBody() {
        return this.getBodyClaimAsZonedDateTime(ClaimName.EXPIRES_AT).orElseThrow();
    }

    public ZonedDateTime getIssuedAt() {
        return this.getBodyClaimAsZonedDateTime(ClaimName.ISSUED_AT).orElseThrow();
    }

    private Optional<ZonedDateTime> getBodyClaimAsZonedDateTime(ClaimName claimName) {
        return this.getBodyClaims().entrySet().stream().filter(entry -> claimName.getJoseName().equals(entry.getKey())).map(Map.Entry::getValue).map(TokenClaimExtraction::claimToZonedDateTime).findAny();
    }

    public Set<String> getScopesBodyClaim() {
        return Optional.ofNullable(this.getBodyClaims().get(ClaimName.SCOPE.getJoseName())).filter(String.class::isInstance).map(String.class::cast).stream().flatMap(value -> Stream.of(value.split(" "))).collect(Collectors.toSet());
    }

    public Optional<String> getStringBodyClaim(ClaimName claimName) {
        return Optional.ofNullable(this.getBodyClaims().get(claimName.getJoseName())).filter(String.class::isInstance).map(String.class::cast);
    }

    public Optional<ZonedDateTime> getBodyDateTimeClaim(ClaimName claimName) {
        return this.getDateTimeClaim(claimName, this::getBodyClaims);
    }

    public Optional<ZonedDateTime> getHeaderDateTimeClaim(ClaimName claimName) {
        return this.getDateTimeClaim(claimName, this::getHeaderClaims);
    }

    public Optional<ZonedDateTime> getDateTimeClaim(ClaimName claimName, Supplier<Map<String, Object>> claims) {
        return Optional.ofNullable(claims.get().get(claimName.getJoseName())).filter(Long.class::isInstance).map(Long.class::cast).map(TokenClaimExtraction::claimToZonedDateTime);
    }

    public String getHeaderDecoded() {
        String[] split = this.getRawString().split("\\.");
        if (split.length < 2) {
            throw new IllegalStateException("Could not retrieve Header: only found " + split.length + " parts!");
        }
        return StringUtils.newStringUtf8((byte[])org.apache.commons.codec.binary.Base64.decodeBase64((String)split[0]));
    }

    public String getPayloadDecoded() {
        String[] split = this.getRawString().split("\\.");
        if (split.length < 2) {
            throw new IllegalStateException("Could not retrieve Body: only found " + split.length + " parts!");
        }
        return StringUtils.newStringUtf8((byte[])org.apache.commons.codec.binary.Base64.decodeBase64((String)split[1]));
    }

    public Optional<Object> getBodyClaim(ClaimName claimName) {
        return Optional.ofNullable(this.getBodyClaims().get(claimName.getJoseName())).filter(Objects::nonNull);
    }

    public Optional<Object> getHeaderClaim(ClaimName claimName) {
        return Optional.ofNullable(this.getHeaderClaims().get(claimName.getJoseName())).filter(Objects::nonNull);
    }

    public Optional<X509Certificate> getClientCertificateFromHeader() {
        return Optional.ofNullable(this.getHeaderClaims().get(ClaimName.X509_CERTIFICATE_CHAIN.getJoseName())).filter(List.class::isInstance).map(List.class::cast).filter(list -> !list.isEmpty()).map(list -> list.get(0)).map(Object::toString).map(Base64.getDecoder()::decode).map(CryptoLoader::getCertificateFromPem);
    }

    public Optional<X509Certificate> getAuthenticationCertificate() {
        return this.getStringBodyClaim(ClaimName.AUTHENTICATION_CERTIFICATE).map(Base64.getUrlDecoder()::decode).map(CryptoLoader::getCertificateFromPem);
    }

    public Optional<JsonWebToken> getNestedJwtForClaimName(ClaimName claimName) {
        return this.getStringBodyClaim(claimName).filter(String.class::isInstance).map(String.class::cast).filter(org.apache.commons.lang3.StringUtils::isNotBlank).map(JsonWebToken::new);
    }

    public String getRawString() {
        return this.rawString;
    }

    @Generated
    public IdpJoseObject(String rawString) {
        this.rawString = rawString;
    }

    public static class Serializer
    extends JsonSerializer<IdpJoseObject> {
        public void serialize(IdpJoseObject value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.getRawString());
        }
    }
}

