/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.idp.crypto.KeyAnalysis;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.data.IdpEccKeyDescriptor;
import de.gematik.idp.data.IdpRsaKeyDescriptor;
import de.gematik.idp.exceptions.IdpJoseException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.json.internal.json_simple.JSONAware;

public class IdpKeyDescriptor
implements JSONAware {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String[] x5c;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="use")
    private String publicKeyUse;
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="kty")
    private String keyType;

    public static String[] getCertArray(X509Certificate certificate) {
        try {
            return new String[]{Base64.getEncoder().encodeToString(certificate.getEncoded())};
        }
        catch (CertificateEncodingException e) {
            throw new IdpCryptoException("Error while retrieving key information", (Exception)e);
        }
    }

    public static IdpKeyDescriptor constructFromX509Certificate(X509Certificate certificate) {
        return IdpKeyDescriptor.constructFromX509Certificate(certificate, Optional.empty(), true);
    }

    public static IdpKeyDescriptor constructFromX509Certificate(X509Certificate certificate, Optional<String> keyId, boolean addX5C) {
        if (KeyAnalysis.isEcKey((PublicKey)certificate.getPublicKey())) {
            return IdpEccKeyDescriptor.constructFromX509Certificate(certificate, keyId.orElse(certificate.getSerialNumber().toString()), addX5C);
        }
        return IdpRsaKeyDescriptor.constructFromX509Certificate(certificate, keyId.orElse(certificate.getSerialNumber().toString()), addX5C);
    }

    public static String getKeyType(X509Certificate certificate) {
        if (KeyAnalysis.isEcKey((PublicKey)certificate.getPublicKey())) {
            return "EC";
        }
        return "RSA";
    }

    public String toJSONString() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IdpJoseException("Error during Claim serialization", (Exception)((Object)e));
        }
    }

    @Generated
    public String[] getX5c() {
        return this.x5c;
    }

    @Generated
    public String getPublicKeyUse() {
        return this.publicKeyUse;
    }

    @Generated
    public String getKeyId() {
        return this.keyId;
    }

    @Generated
    public String getKeyType() {
        return this.keyType;
    }

    @Generated
    public void setX5c(String[] x5c) {
        this.x5c = x5c;
    }

    @JsonProperty(value="use")
    @Generated
    public void setPublicKeyUse(String publicKeyUse) {
        this.publicKeyUse = publicKeyUse;
    }

    @JsonProperty(value="kid")
    @Generated
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @JsonProperty(value="kty")
    @Generated
    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdpKeyDescriptor)) {
            return false;
        }
        IdpKeyDescriptor other = (IdpKeyDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getX5c(), other.getX5c())) {
            return false;
        }
        String this$publicKeyUse = this.getPublicKeyUse();
        String other$publicKeyUse = other.getPublicKeyUse();
        if (this$publicKeyUse == null ? other$publicKeyUse != null : !this$publicKeyUse.equals(other$publicKeyUse)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$keyType = this.getKeyType();
        String other$keyType = other.getKeyType();
        return !(this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdpKeyDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getX5c());
        String $publicKeyUse = this.getPublicKeyUse();
        result = result * 59 + ($publicKeyUse == null ? 43 : $publicKeyUse.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        return result;
    }

    @Generated
    public IdpKeyDescriptor() {
    }

    @Generated
    public IdpKeyDescriptor(String[] x5c, String publicKeyUse, String keyId, String keyType) {
        this.x5c = x5c;
        this.publicKeyUse = publicKeyUse;
        this.keyId = keyId;
        this.keyType = keyType;
    }
}

