/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.gematik.idp.crypto.exceptions.IdpCryptoException;
import de.gematik.idp.data.IdpKeyDescriptor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import lombok.Generated;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.jose4j.base64url.Base64Url;

public class IdpEccKeyDescriptor
extends IdpKeyDescriptor {
    @JsonProperty(value="crv")
    private String eccCurveName;
    @JsonProperty(value="x")
    private String eccPointXValue;
    @JsonProperty(value="y")
    private String eccPointYValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="alg")
    private String alg;

    public IdpEccKeyDescriptor(String[] x5c, String publicKeyUse, String keyId, String keyType, String eccCurveName, String eccPointXValue, String eccPointYValue, String alg) {
        super(x5c, publicKeyUse, keyId, keyType);
        this.eccCurveName = eccCurveName;
        this.eccPointXValue = eccPointXValue;
        this.eccPointYValue = eccPointYValue;
        this.alg = alg;
    }

    public static IdpKeyDescriptor constructFromX509Certificate(X509Certificate certificate, String keyId, boolean addX5C) {
        try {
            IdpEccKeyDescriptorBuilder descriptorBuilder = IdpEccKeyDescriptor.builder().keyId(keyId).keyType(IdpEccKeyDescriptor.getKeyType(certificate));
            if (addX5C) {
                descriptorBuilder.x5c(IdpEccKeyDescriptor.getCertArray(certificate));
            }
            BCECPublicKey bcecPublicKey = (BCECPublicKey)certificate.getPublicKey();
            String eccCurveName = "";
            String alg = null;
            if (((ECNamedCurveParameterSpec)bcecPublicKey.getParameters()).getName().equals("brainpoolP256r1")) {
                eccCurveName = "BP-256";
            } else if (((ECNamedCurveParameterSpec)bcecPublicKey.getParameters()).getName().equals("prime256v1")) {
                eccCurveName = "P-256";
                alg = "ES256";
            } else {
                throw new IdpCryptoException("Unknown Key-Format encountered: '" + ((ECNamedCurveParameterSpec)bcecPublicKey.getParameters()).getName() + "'!");
            }
            ECPoint generator = bcecPublicKey.getQ();
            descriptorBuilder.eccCurveName(eccCurveName).eccPointXValue(Base64Url.encode((byte[])generator.getAffineXCoord().getEncoded())).eccPointYValue(Base64Url.encode((byte[])generator.getAffineYCoord().getEncoded())).alg(alg);
            return descriptorBuilder.build();
        }
        catch (ClassCastException e) {
            throw new IdpCryptoException("Unknown Key-Format encountered!", (Exception)e);
        }
    }

    @Generated
    public static IdpEccKeyDescriptorBuilder builder() {
        return new IdpEccKeyDescriptorBuilder();
    }

    @Generated
    public String getEccCurveName() {
        return this.eccCurveName;
    }

    @Generated
    public String getEccPointXValue() {
        return this.eccPointXValue;
    }

    @Generated
    public String getEccPointYValue() {
        return this.eccPointYValue;
    }

    @Generated
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="crv")
    @Generated
    public void setEccCurveName(String eccCurveName) {
        this.eccCurveName = eccCurveName;
    }

    @JsonProperty(value="x")
    @Generated
    public void setEccPointXValue(String eccPointXValue) {
        this.eccPointXValue = eccPointXValue;
    }

    @JsonProperty(value="y")
    @Generated
    public void setEccPointYValue(String eccPointYValue) {
        this.eccPointYValue = eccPointYValue;
    }

    @JsonProperty(value="alg")
    @Generated
    public void setAlg(String alg) {
        this.alg = alg;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdpEccKeyDescriptor)) {
            return false;
        }
        IdpEccKeyDescriptor other = (IdpEccKeyDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$eccCurveName = this.getEccCurveName();
        String other$eccCurveName = other.getEccCurveName();
        if (this$eccCurveName == null ? other$eccCurveName != null : !this$eccCurveName.equals(other$eccCurveName)) {
            return false;
        }
        String this$eccPointXValue = this.getEccPointXValue();
        String other$eccPointXValue = other.getEccPointXValue();
        if (this$eccPointXValue == null ? other$eccPointXValue != null : !this$eccPointXValue.equals(other$eccPointXValue)) {
            return false;
        }
        String this$eccPointYValue = this.getEccPointYValue();
        String other$eccPointYValue = other.getEccPointYValue();
        if (this$eccPointYValue == null ? other$eccPointYValue != null : !this$eccPointYValue.equals(other$eccPointYValue)) {
            return false;
        }
        String this$alg = this.getAlg();
        String other$alg = other.getAlg();
        return !(this$alg == null ? other$alg != null : !this$alg.equals(other$alg));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdpEccKeyDescriptor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eccCurveName = this.getEccCurveName();
        result = result * 59 + ($eccCurveName == null ? 43 : $eccCurveName.hashCode());
        String $eccPointXValue = this.getEccPointXValue();
        result = result * 59 + ($eccPointXValue == null ? 43 : $eccPointXValue.hashCode());
        String $eccPointYValue = this.getEccPointYValue();
        result = result * 59 + ($eccPointYValue == null ? 43 : $eccPointYValue.hashCode());
        String $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : $alg.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdpEccKeyDescriptor(eccCurveName=" + this.getEccCurveName() + ", eccPointXValue=" + this.getEccPointXValue() + ", eccPointYValue=" + this.getEccPointYValue() + ", alg=" + this.getAlg() + ")";
    }

    @Generated
    public IdpEccKeyDescriptor(String eccCurveName, String eccPointXValue, String eccPointYValue, String alg) {
        this.eccCurveName = eccCurveName;
        this.eccPointXValue = eccPointXValue;
        this.eccPointYValue = eccPointYValue;
        this.alg = alg;
    }

    @Generated
    public IdpEccKeyDescriptor() {
    }

    @Generated
    public static class IdpEccKeyDescriptorBuilder {
        @Generated
        private String[] x5c;
        @Generated
        private String publicKeyUse;
        @Generated
        private String keyId;
        @Generated
        private String keyType;
        @Generated
        private String eccCurveName;
        @Generated
        private String eccPointXValue;
        @Generated
        private String eccPointYValue;
        @Generated
        private String alg;

        @Generated
        IdpEccKeyDescriptorBuilder() {
        }

        @Generated
        public IdpEccKeyDescriptorBuilder x5c(String[] x5c) {
            this.x5c = x5c;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder publicKeyUse(String publicKeyUse) {
            this.publicKeyUse = publicKeyUse;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder eccCurveName(String eccCurveName) {
            this.eccCurveName = eccCurveName;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder eccPointXValue(String eccPointXValue) {
            this.eccPointXValue = eccPointXValue;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder eccPointYValue(String eccPointYValue) {
            this.eccPointYValue = eccPointYValue;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptorBuilder alg(String alg) {
            this.alg = alg;
            return this;
        }

        @Generated
        public IdpEccKeyDescriptor build() {
            return new IdpEccKeyDescriptor(this.x5c, this.publicKeyUse, this.keyId, this.keyType, this.eccCurveName, this.eccPointXValue, this.eccPointYValue, this.alg);
        }

        @Generated
        public String toString() {
            return "IdpEccKeyDescriptor.IdpEccKeyDescriptorBuilder(x5c=" + Arrays.deepToString(this.x5c) + ", publicKeyUse=" + this.publicKeyUse + ", keyId=" + this.keyId + ", keyType=" + this.keyType + ", eccCurveName=" + this.eccCurveName + ", eccPointXValue=" + this.eccPointXValue + ", eccPointYValue=" + this.eccPointYValue + ", alg=" + this.alg + ")";
        }
    }
}

