/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.brainPoolExtension;

import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuites;
import de.gematik.idp.exceptions.IdpJoseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.spec.ECParameterSpec;
import lombok.Generated;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.jose4j.jwa.Algorithm;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.keys.EllipticCurves;

public class BrainpoolCurves {
    public static final String BP_256 = "BP-256";
    public static final String BP_384 = "BP-384";
    public static final String BP_512 = "BP-512";
    private static final ECNamedCurveParameterSpec EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1 = ECNamedCurveTable.getParameterSpec((String)"brainpoolP256r1");
    private static final ECNamedCurveParameterSpec EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1 = ECNamedCurveTable.getParameterSpec((String)"brainpoolP384r1");
    private static final ECNamedCurveParameterSpec EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1 = ECNamedCurveTable.getParameterSpec((String)"brainpoolP512r1");
    private static final ECParameterSpec EC_PARAMETER_SPEC_BP256R1;
    public static final ECParameterSpec BP256;
    private static final ECParameterSpec EC_PARAMETER_SPEC_BP384R1;
    public static final ECParameterSpec BP384;
    private static final ECParameterSpec EC_PARAMETER_SPEC_BP512R1;
    public static final ECParameterSpec BP512;
    private static boolean initialized;

    private static void addCurve(String name, ECParameterSpec spec) {
        try {
            Method method = EllipticCurves.class.getDeclaredMethod("addCurve", String.class, ECParameterSpec.class);
            method.setAccessible(true);
            method.invoke(BrainpoolCurves.class, name, spec);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IdpJoseException("Error while adding BrainPool-Curves " + name + " to internal Algorithm-Suite repository", e);
        }
    }

    public static void init() {
        if (initialized) {
            return;
        }
        BrainpoolCurves.addCurve(BP_256, BP256);
        BrainpoolCurves.addCurve(BP_384, BP384);
        BrainpoolCurves.addCurve(BP_512, BP512);
        AlgorithmFactoryFactory.getInstance().getJwsAlgorithmFactory().registerAlgorithm((Algorithm)new BrainpoolAlgorithmSuites.EcdsaBP256R1UsingSha256());
        AlgorithmFactoryFactory.getInstance().getJwsAlgorithmFactory().registerAlgorithm((Algorithm)new BrainpoolAlgorithmSuites.EcdsaBP384R1UsingSha384());
        AlgorithmFactoryFactory.getInstance().getJwsAlgorithmFactory().registerAlgorithm((Algorithm)new BrainpoolAlgorithmSuites.EcdsaBP512R1UsingSha512());
        initialized = true;
    }

    @Generated
    private BrainpoolCurves() {
    }

    static {
        BP256 = EC_PARAMETER_SPEC_BP256R1 = new ECNamedCurveSpec("brainpoolP256r1", EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1.getCurve(), EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1.getG(), EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1.getN(), EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1.getH(), EC_NAMED_CURVE_PARAMETER_SPEC_BP256R1.getSeed());
        BP384 = EC_PARAMETER_SPEC_BP384R1 = new ECNamedCurveSpec("brainpoolP384r1", EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1.getCurve(), EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1.getG(), EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1.getN(), EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1.getH(), EC_NAMED_CURVE_PARAMETER_SPEC_BP384R1.getSeed());
        BP512 = EC_PARAMETER_SPEC_BP512R1 = new ECNamedCurveSpec("brainpoolP512r1", EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1.getCurve(), EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1.getG(), EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1.getN(), EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1.getH(), EC_NAMED_CURVE_PARAMETER_SPEC_BP512R1.getSeed());
    }
}

