/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.exceptions.IdpJwtExpiredException;
import de.gematik.idp.exceptions.IdpJwtSignatureInvalidException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJoseObject;
import de.gematik.idp.token.IdpJwe;
import de.gematik.idp.token.TokenClaimExtraction;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

@JsonSerialize(using=IdpJoseObject.Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class JsonWebToken
extends IdpJoseObject {
    public JsonWebToken(String rawString) {
        super(rawString);
    }

    public void verify(PublicKey publicKey) {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setVerificationKey((Key)publicKey).setSkipDefaultAudienceValidation().build();
        try {
            jwtConsumer.process(this.getRawString());
        }
        catch (InvalidJwtException e) {
            if (e.getErrorDetails().stream().anyMatch(error -> error.getErrorCode() == 1)) {
                throw new IdpJwtExpiredException((Exception)((Object)e));
            }
            if (e.getErrorDetails().stream().anyMatch(error -> error.getErrorCode() == 9)) {
                throw new IdpJwtSignatureInvalidException((Exception)((Object)e));
            }
            throw new IdpJoseException("Invalid JWT encountered", (Exception)((Object)e));
        }
    }

    public JwtBuilder toJwtDescription() {
        return new JwtBuilder().addAllBodyClaims(this.getBodyClaims()).addAllHeaderClaims(this.getHeaderClaims());
    }

    @Deprecated(since="24.1.0", forRemoval=true)
    public IdpJwe encrypt(Key key) {
        return this.encryptAsNjwt(key);
    }

    public IdpJwe encryptAsNjwt(Key key) {
        Consumer<JsonWebEncryption> setContentTypeAndExp = jwe -> {
            jwe.setHeader(ClaimName.CONTENT_TYPE.getJoseName(), "NJWT");
            this.findExpClaimInNestedJwts().map(TokenClaimExtraction::zonedDateTimeToClaim).ifPresent(expValue -> jwe.setHeader(ClaimName.EXPIRES_AT.getJoseName(), expValue));
        };
        return IdpJwe.createJweWithPayloadAndHeaders("{\"njwt\":\"" + this.getRawString() + "\"}", key, setContentTypeAndExp);
    }

    public IdpJwe encryptAsJwt(JsonWebKey key) {
        Consumer<JsonWebEncryption> setContentTypeAndKid = jwe -> {
            jwe.setHeader(ClaimName.CONTENT_TYPE.getJoseName(), "JWT");
            jwe.setHeader(ClaimName.KEY_ID.getJoseName(), key.getKeyId());
        };
        return IdpJwe.createJweWithPayloadAndHeaders(this.getRawString(), key.getKey(), setContentTypeAndKid);
    }

    public Optional<ZonedDateTime> findExpClaimInNestedJwts() {
        Optional<ZonedDateTime> expClaim = this.getBodyDateTimeClaim(ClaimName.EXPIRES_AT);
        if (expClaim.isPresent()) {
            return expClaim;
        }
        Optional<Object> njwtClaim = this.getBodyClaim(ClaimName.NESTED_JWT);
        if (njwtClaim.isPresent()) {
            return new JsonWebToken(njwtClaim.get().toString()).findExpClaimInNestedJwts();
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Object> extractHeaderClaims() {
        return TokenClaimExtraction.extractClaimsFromJwtHeader(this.getRawString());
    }

    @Override
    public Map<String, Object> extractBodyClaims() {
        return TokenClaimExtraction.extractClaimsFromJwtBody(this.getRawString());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonWebToken)) {
            return false;
        }
        JsonWebToken other = (JsonWebToken)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonWebToken;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static class Deserializer
    extends JsonDeserializer<IdpJoseObject> {
        public IdpJoseObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new JsonWebToken((String)ctxt.readValue(p, String.class));
        }
    }
}

