/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.exceptions.IdpRuntimeException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class UriUtils {
    public static Optional<String> extractParameterValueOptional(String uri, String parameterName) {
        try {
            return Stream.of(new URI(uri).getQuery().split("&")).filter(str -> str.startsWith(parameterName + "=")).map(str -> str.replace(parameterName + "=", "")).findAny();
        }
        catch (URISyntaxException e) {
            throw new IdpRuntimeException(e);
        }
    }

    public static Map<String, String> extractParameterMap(String uri) {
        try {
            return Stream.of(new URI(uri).getQuery().split("&")).filter(param -> param.contains("=")).map(param -> param.split("=")).collect(Collectors.toMap(array -> array[0], array -> array[1]));
        }
        catch (URISyntaxException e) {
            throw new IdpRuntimeException(e);
        }
    }

    public static String extractParameterValue(String uri, String param) {
        return UriUtils.extractParameterValueOptional(uri, param).orElseThrow(() -> new RuntimeException("Could not find '" + param + "' parameter in '" + uri + "'"));
    }

    @Generated
    private UriUtils() {
    }
}

