/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.AuthenticationChallenge;
import de.gematik.idp.authentication.AuthenticationResponse;
import de.gematik.idp.brainPoolExtension.BrainpoolAlgorithmSuiteIdentifiers;
import de.gematik.idp.crypto.KeyAnalysis;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.exceptions.IdpRuntimeException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

public class AuthenticationResponseBuilder {
    public AuthenticationResponse buildResponseForChallenge(AuthenticationChallenge authenticationChallenge, PkiIdentity clientIdentity) {
        JwtClaims claims = new JwtClaims();
        claims.setClaim(ClaimName.NESTED_JWT.getJoseName(), (Object)authenticationChallenge.getChallenge().getRawString());
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        jsonWebSignature.setPayload(claims.toJson());
        if (KeyAnalysis.isEcKey((PublicKey)clientIdentity.getCertificate().getPublicKey())) {
            jsonWebSignature.setAlgorithmHeaderValue(BrainpoolAlgorithmSuiteIdentifiers.BRAINPOOL256_USING_SHA256);
        } else {
            jsonWebSignature.setAlgorithmHeaderValue("PS256");
        }
        jsonWebSignature.setKey((Key)clientIdentity.getPrivateKey());
        jsonWebSignature.setHeader("typ", "JWT");
        jsonWebSignature.setHeader("cty", "NJWT");
        jsonWebSignature.setCertificateChainHeaderValue(new X509Certificate[]{clientIdentity.getCertificate()});
        try {
            String compactSerialization = jsonWebSignature.getCompactSerialization();
            return AuthenticationResponse.builder().signedChallenge(new JsonWebToken(compactSerialization)).build();
        }
        catch (JoseException e) {
            throw new IdpRuntimeException((Exception)((Object)e));
        }
    }

    @Generated
    public static AuthenticationResponseBuilderBuilder builder() {
        return new AuthenticationResponseBuilderBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationResponseBuilder)) {
            return false;
        }
        AuthenticationResponseBuilder other = (AuthenticationResponseBuilder)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationResponseBuilder;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "AuthenticationResponseBuilder()";
    }

    @Generated
    public AuthenticationResponseBuilder() {
    }

    @Generated
    public static class AuthenticationResponseBuilderBuilder {
        @Generated
        AuthenticationResponseBuilderBuilder() {
        }

        @Generated
        public AuthenticationResponseBuilder build() {
            return new AuthenticationResponseBuilder();
        }

        @Generated
        public String toString() {
            return "AuthenticationResponseBuilder.AuthenticationResponseBuilderBuilder()";
        }
    }
}

