/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.authentication;

import de.gematik.idp.authentication.AuthenticationChallenge;
import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.data.ScopeConfiguration;
import de.gematik.idp.data.UserConsent;
import de.gematik.idp.data.UserConsentConfiguration;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class AuthenticationChallengeBuilder {
    private static final long CHALLENGE_TOKEN_VALIDITY_IN_MINUTES = 3L;
    private static final int NONCE_BYTE_AMOUNT = 32;
    private final IdpJwtProcessor serverSigner;
    private final String uriIdpServer;
    private final UserConsentConfiguration userConsentConfiguration;
    private final Map<String, ScopeConfiguration> scopesConfiguration;

    public AuthenticationChallenge buildAuthenticationChallenge(String clientId, String state, String redirect, String code, String scope, String nonce) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(ClaimName.ISSUER.getJoseName(), this.uriIdpServer);
        ZonedDateTime now = ZonedDateTime.now();
        claims.put(ClaimName.EXPIRES_AT.getJoseName(), now.plusMinutes(3L).toEpochSecond());
        claims.put(ClaimName.ISSUED_AT.getJoseName(), now.toEpochSecond());
        claims.put(ClaimName.RESPONSE_TYPE.getJoseName(), "code");
        claims.put(ClaimName.SCOPE.getJoseName(), scope);
        claims.put(ClaimName.CLIENT_ID.getJoseName(), clientId);
        claims.put(ClaimName.STATE.getJoseName(), state);
        claims.put(ClaimName.REDIRECT_URI.getJoseName(), redirect);
        claims.put(ClaimName.CODE_CHALLENGE_METHOD.getJoseName(), "S256");
        claims.put(ClaimName.CODE_CHALLENGE.getJoseName(), code);
        claims.put(ClaimName.TOKEN_TYPE.getJoseName(), "challenge");
        if (nonce != null) {
            claims.put(ClaimName.NONCE.getJoseName(), nonce);
        }
        claims.put(ClaimName.SERVER_NONCE.getJoseName(), Nonce.getNonceAsBase64UrlEncodedString((int)32));
        claims.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        HashMap<String, Object> headerClaims = new HashMap<String, Object>();
        headerClaims.put(ClaimName.TYPE.getJoseName(), "JWT");
        UserConsent userConsent = this.getUserConsent(scope);
        return AuthenticationChallenge.builder().challenge(this.buildJwt(claims, headerClaims)).userConsent(userConsent).build();
    }

    private UserConsent getUserConsent(String scopes) {
        List<String> requestedScopes = Stream.of(scopes.split(" ")).filter(this.scopesConfiguration::containsKey).toList();
        Map<String, String> scopeMap = requestedScopes.stream().map(s -> Pair.of((Object)s, (Object)this.scopesConfiguration.get(s).getDescription())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Map<String, String> clientMap = requestedScopes.stream().filter(id -> this.scopesConfiguration.get(id).getClaimsToBeIncluded() != null).map(id -> this.scopesConfiguration.get(id).getClaimsToBeIncluded()).flatMap(Collection::stream).distinct().map(s -> Pair.of((Object)s.getJoseName(), (Object)this.userConsentConfiguration.getDescriptionTexts().getClaims().get(s))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        return UserConsent.builder().requestedScopes(scopeMap).requestedClaims(clientMap).build();
    }

    private JsonWebToken buildJwt(Map<String, Object> bodyClaims, Map<String, Object> headerClaims) {
        return this.serverSigner.buildJwt(new JwtBuilder().addAllBodyClaims(bodyClaims).addAllHeaderClaims(headerClaims));
    }

    @Generated
    public static AuthenticationChallengeBuilderBuilder builder() {
        return new AuthenticationChallengeBuilderBuilder();
    }

    @Generated
    public IdpJwtProcessor getServerSigner() {
        return this.serverSigner;
    }

    @Generated
    public String getUriIdpServer() {
        return this.uriIdpServer;
    }

    @Generated
    public UserConsentConfiguration getUserConsentConfiguration() {
        return this.userConsentConfiguration;
    }

    @Generated
    public Map<String, ScopeConfiguration> getScopesConfiguration() {
        return this.scopesConfiguration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationChallengeBuilder)) {
            return false;
        }
        AuthenticationChallengeBuilder other = (AuthenticationChallengeBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdpJwtProcessor this$serverSigner = this.getServerSigner();
        IdpJwtProcessor other$serverSigner = other.getServerSigner();
        if (this$serverSigner == null ? other$serverSigner != null : !this$serverSigner.equals(other$serverSigner)) {
            return false;
        }
        String this$uriIdpServer = this.getUriIdpServer();
        String other$uriIdpServer = other.getUriIdpServer();
        if (this$uriIdpServer == null ? other$uriIdpServer != null : !this$uriIdpServer.equals(other$uriIdpServer)) {
            return false;
        }
        UserConsentConfiguration this$userConsentConfiguration = this.getUserConsentConfiguration();
        UserConsentConfiguration other$userConsentConfiguration = other.getUserConsentConfiguration();
        if (this$userConsentConfiguration == null ? other$userConsentConfiguration != null : !((Object)this$userConsentConfiguration).equals(other$userConsentConfiguration)) {
            return false;
        }
        Map<String, ScopeConfiguration> this$scopesConfiguration = this.getScopesConfiguration();
        Map<String, ScopeConfiguration> other$scopesConfiguration = other.getScopesConfiguration();
        return !(this$scopesConfiguration == null ? other$scopesConfiguration != null : !((Object)this$scopesConfiguration).equals(other$scopesConfiguration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationChallengeBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdpJwtProcessor $serverSigner = this.getServerSigner();
        result = result * 59 + ($serverSigner == null ? 43 : $serverSigner.hashCode());
        String $uriIdpServer = this.getUriIdpServer();
        result = result * 59 + ($uriIdpServer == null ? 43 : $uriIdpServer.hashCode());
        UserConsentConfiguration $userConsentConfiguration = this.getUserConsentConfiguration();
        result = result * 59 + ($userConsentConfiguration == null ? 43 : ((Object)$userConsentConfiguration).hashCode());
        Map<String, ScopeConfiguration> $scopesConfiguration = this.getScopesConfiguration();
        result = result * 59 + ($scopesConfiguration == null ? 43 : ((Object)$scopesConfiguration).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationChallengeBuilder(serverSigner=" + this.getServerSigner() + ", uriIdpServer=" + this.getUriIdpServer() + ", userConsentConfiguration=" + this.getUserConsentConfiguration() + ", scopesConfiguration=" + this.getScopesConfiguration() + ")";
    }

    @Generated
    public AuthenticationChallengeBuilder(IdpJwtProcessor serverSigner, String uriIdpServer, UserConsentConfiguration userConsentConfiguration, Map<String, ScopeConfiguration> scopesConfiguration) {
        this.serverSigner = serverSigner;
        this.uriIdpServer = uriIdpServer;
        this.userConsentConfiguration = userConsentConfiguration;
        this.scopesConfiguration = scopesConfiguration;
    }

    @Generated
    public static class AuthenticationChallengeBuilderBuilder {
        @Generated
        private IdpJwtProcessor serverSigner;
        @Generated
        private String uriIdpServer;
        @Generated
        private UserConsentConfiguration userConsentConfiguration;
        @Generated
        private Map<String, ScopeConfiguration> scopesConfiguration;

        @Generated
        AuthenticationChallengeBuilderBuilder() {
        }

        @Generated
        public AuthenticationChallengeBuilderBuilder serverSigner(IdpJwtProcessor serverSigner) {
            this.serverSigner = serverSigner;
            return this;
        }

        @Generated
        public AuthenticationChallengeBuilderBuilder uriIdpServer(String uriIdpServer) {
            this.uriIdpServer = uriIdpServer;
            return this;
        }

        @Generated
        public AuthenticationChallengeBuilderBuilder userConsentConfiguration(UserConsentConfiguration userConsentConfiguration) {
            this.userConsentConfiguration = userConsentConfiguration;
            return this;
        }

        @Generated
        public AuthenticationChallengeBuilderBuilder scopesConfiguration(Map<String, ScopeConfiguration> scopesConfiguration) {
            this.scopesConfiguration = scopesConfiguration;
            return this;
        }

        @Generated
        public AuthenticationChallengeBuilder build() {
            return new AuthenticationChallengeBuilder(this.serverSigner, this.uriIdpServer, this.userConsentConfiguration, this.scopesConfiguration);
        }

        @Generated
        public String toString() {
            return "AuthenticationChallengeBuilder.AuthenticationChallengeBuilderBuilder(serverSigner=" + this.serverSigner + ", uriIdpServer=" + this.uriIdpServer + ", userConsentConfiguration=" + this.userConsentConfiguration + ", scopesConfiguration=" + this.scopesConfiguration + ")";
        }
    }
}

