/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import de.gematik.idp.authentication.IdpJwtProcessor;
import de.gematik.idp.authentication.JwtBuilder;
import de.gematik.idp.crypto.Nonce;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.JsonWebToken;
import de.gematik.idp.token.TokenBuilderUtil;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwt.NumericDate;

public class IdTokenBuilder {
    private static final List<ClaimName> CLAIMS_TO_TAKE_FROM_AUTHENTICATION_TOKEN = List.of(ClaimName.GIVEN_NAME, ClaimName.FAMILY_NAME, ClaimName.ORGANIZATION_NAME, ClaimName.PROFESSION_OID, ClaimName.ID_NUMBER, ClaimName.AUTH_TIME, ClaimName.NONCE);
    private final IdpJwtProcessor jwtProcessor;
    private final String issuerUrl;
    private final String serverSubjectSalt;

    public JsonWebToken buildIdToken(String clientId, JsonWebToken authenticationToken, JsonWebToken accessToken) {
        HashMap<String, Object> claimsMap = new HashMap<String, Object>();
        ZonedDateTime now = ZonedDateTime.now();
        String atHashValue = Base64.getUrlEncoder().withoutPadding().encodeToString(ArrayUtils.subarray((byte[])DigestUtils.sha256((String)accessToken.getRawString()), (int)0, (int)16));
        claimsMap.put(ClaimName.ISSUER.getJoseName(), this.issuerUrl);
        claimsMap.put(ClaimName.AUDIENCE.getJoseName(), clientId);
        claimsMap.put(ClaimName.ISSUED_AT.getJoseName(), now.toEpochSecond());
        CLAIMS_TO_TAKE_FROM_AUTHENTICATION_TOKEN.stream().map(claimName -> Pair.of((Object)claimName, authenticationToken.getBodyClaim((ClaimName)((Object)claimName)))).filter(pair -> ((Optional)pair.getValue()).isPresent()).forEach(pair -> claimsMap.put(((ClaimName)((Object)((Object)pair.getKey()))).getJoseName(), ((Optional)pair.getValue()).get()));
        claimsMap.put(ClaimName.AUTHORIZED_PARTY.getJoseName(), authenticationToken.getBodyClaim(ClaimName.CLIENT_ID).orElseThrow(() -> new IdpJoseException("Missing '" + ClaimName.AUTHORIZED_PARTY.getJoseName() + "' claim!")));
        claimsMap.put(ClaimName.AUTHENTICATION_METHODS_REFERENCE.getJoseName(), authenticationToken.getBodyClaim(ClaimName.AUTHENTICATION_METHODS_REFERENCE).or(() -> accessToken.getBodyClaim(ClaimName.AUTHENTICATION_METHODS_REFERENCE)).orElseThrow());
        claimsMap.put(ClaimName.AUTHENTICATION_CLASS_REFERENCE.getJoseName(), "gematik-ehealth-loa-high");
        claimsMap.put(ClaimName.ACCESS_TOKEN_HASH.getJoseName(), atHashValue);
        claimsMap.put(ClaimName.SUBJECT.getJoseName(), TokenBuilderUtil.buildSubjectClaim(clientId, authenticationToken.getStringBodyClaim(ClaimName.ID_NUMBER).orElseThrow(() -> new IdpJoseException("Missing '" + ClaimName.ID_NUMBER.getJoseName() + "' claim!")), this.serverSubjectSalt));
        claimsMap.put(ClaimName.JWT_ID.getJoseName(), Nonce.getNonceAsHex((int)16));
        claimsMap.put(ClaimName.EXPIRES_AT.getJoseName(), NumericDate.fromSeconds((long)now.plusMinutes(5L).toEpochSecond()).getValue());
        HashMap<String, Object> headerClaims = new HashMap<String, Object>();
        headerClaims.put(ClaimName.TYPE.getJoseName(), "JWT");
        return this.jwtProcessor.buildJwt(new JwtBuilder().addAllBodyClaims(claimsMap).addAllHeaderClaims(headerClaims));
    }

    @Generated
    public IdTokenBuilder(IdpJwtProcessor jwtProcessor, String issuerUrl, String serverSubjectSalt) {
        this.jwtProcessor = jwtProcessor;
        this.issuerUrl = issuerUrl;
        this.serverSubjectSalt = serverSubjectSalt;
    }

    @Generated
    public IdpJwtProcessor getJwtProcessor() {
        return this.jwtProcessor;
    }

    @Generated
    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    @Generated
    public String getServerSubjectSalt() {
        return this.serverSubjectSalt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdTokenBuilder)) {
            return false;
        }
        IdTokenBuilder other = (IdTokenBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IdpJwtProcessor this$jwtProcessor = this.getJwtProcessor();
        IdpJwtProcessor other$jwtProcessor = other.getJwtProcessor();
        if (this$jwtProcessor == null ? other$jwtProcessor != null : !this$jwtProcessor.equals(other$jwtProcessor)) {
            return false;
        }
        String this$issuerUrl = this.getIssuerUrl();
        String other$issuerUrl = other.getIssuerUrl();
        if (this$issuerUrl == null ? other$issuerUrl != null : !this$issuerUrl.equals(other$issuerUrl)) {
            return false;
        }
        String this$serverSubjectSalt = this.getServerSubjectSalt();
        String other$serverSubjectSalt = other.getServerSubjectSalt();
        return !(this$serverSubjectSalt == null ? other$serverSubjectSalt != null : !this$serverSubjectSalt.equals(other$serverSubjectSalt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdTokenBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IdpJwtProcessor $jwtProcessor = this.getJwtProcessor();
        result = result * 59 + ($jwtProcessor == null ? 43 : $jwtProcessor.hashCode());
        String $issuerUrl = this.getIssuerUrl();
        result = result * 59 + ($issuerUrl == null ? 43 : $issuerUrl.hashCode());
        String $serverSubjectSalt = this.getServerSubjectSalt();
        result = result * 59 + ($serverSubjectSalt == null ? 43 : $serverSubjectSalt.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IdTokenBuilder(jwtProcessor=" + this.getJwtProcessor() + ", issuerUrl=" + this.getIssuerUrl() + ", serverSubjectSalt=" + this.getServerSubjectSalt() + ")";
    }
}

