/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.idp.token;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.gematik.idp.exceptions.IdpJoseException;
import de.gematik.idp.field.ClaimName;
import de.gematik.idp.token.IdpJoseObject;
import de.gematik.idp.token.JsonWebToken;
import de.gematik.idp.token.TokenClaimExtraction;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

@JsonSerialize(using=IdpJoseObject.Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class IdpJwe
extends IdpJoseObject {
    private Key decryptionKey;

    public IdpJwe(String rawString) {
        super(rawString);
    }

    public static IdpJwe createWithPayloadAndEncryptWithKey(String payload, Key key, String contentType) {
        return IdpJwe.createWithPayloadAndExpiryAndEncryptWithKey(payload, Optional.empty(), key, contentType);
    }

    public static IdpJwe createWithPayloadAndExpiryAndEncryptWithKey(String payload, Optional<ZonedDateTime> expiryOptional, Key key, String contentType) {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(payload);
        if (key instanceof PublicKey) {
            jwe.setAlgorithmHeaderValue("ECDH-ES");
        } else {
            jwe.setAlgorithmHeaderValue("dir");
        }
        jwe.setEncryptionMethodHeaderParameter("A256GCM");
        jwe.setKey(key);
        expiryOptional.map(TokenClaimExtraction::zonedDateTimeToClaim).ifPresent(expValue -> jwe.setHeader(ClaimName.EXPIRES_AT.getJoseName(), expValue));
        jwe.setHeader(ClaimName.CONTENT_TYPE.getJoseName(), contentType);
        try {
            return new IdpJwe(jwe.getCompactSerialization());
        }
        catch (JoseException e) {
            throw new IdpJoseException("Error during token encryption", (Exception)((Object)e));
        }
    }

    public JsonWebToken decryptNestedJwt(Key key) {
        this.setDecryptionKey(key);
        return new JsonWebToken(this.getStringBodyClaim(ClaimName.NESTED_JWT).orElseThrow(() -> new IdpJoseException("Could not find njwt")));
    }

    @Override
    public ZonedDateTime getExpiresAt() {
        return this.getDateTimeClaim(ClaimName.EXPIRES_AT, this::getHeaderClaims).orElseThrow();
    }

    public String decryptJweAndReturnPayloadString(Key key) {
        JsonWebEncryption receiverJwe = new JsonWebEncryption();
        receiverJwe.setAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"dir", "ECDH-ES"}));
        receiverJwe.setContentEncryptionAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.PERMIT, new String[]{"A256GCM"}));
        try {
            receiverJwe.setCompactSerialization(this.getRawString());
            receiverJwe.setKey(key);
            return receiverJwe.getPlaintextString();
        }
        catch (JoseException e) {
            throw new IdpJoseException("Error during decryption", (Exception)((Object)e));
        }
    }

    @Override
    public Map<String, Object> extractHeaderClaims() {
        JsonWebEncryption jwe = new JsonWebEncryption();
        try {
            jwe.setCompactSerialization(this.getRawString());
            return JsonUtil.parseJson((String)jwe.getHeaders().getFullHeaderAsJsonString());
        }
        catch (JoseException e) {
            throw new IdpJoseException((Exception)((Object)e));
        }
    }

    public IdpJwe setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
        return this;
    }

    @Override
    public Map<String, Object> extractBodyClaims() {
        Objects.requireNonNull(this.decryptionKey, "Body-claim extraction requires non-null decryption key");
        try {
            return JsonUtil.parseJson((String)this.decryptJweAndReturnPayloadString(this.decryptionKey));
        }
        catch (JoseException e) {
            throw new IdpJoseException("Exception occurred during body-claim extraction", (Exception)((Object)e));
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdpJwe)) {
            return false;
        }
        IdpJwe other = (IdpJwe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$decryptionKey = this.getDecryptionKey();
        Key other$decryptionKey = other.getDecryptionKey();
        return !(this$decryptionKey == null ? other$decryptionKey != null : !this$decryptionKey.equals(other$decryptionKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdpJwe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $decryptionKey = this.getDecryptionKey();
        result = result * 59 + ($decryptionKey == null ? 43 : $decryptionKey.hashCode());
        return result;
    }

    @Generated
    public Key getDecryptionKey() {
        return this.decryptionKey;
    }

    public static class Deserializer
    extends JsonDeserializer<IdpJoseObject> {
        public IdpJoseObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new IdpJwe((String)ctxt.readValue(p, String.class));
        }
    }
}

